/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.processing.ProcessingResult;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorMap;
import com.github.fge.jsonschema.processors.data.SchemaHolder;
import com.github.fge.jsonschema.processors.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.DevNullProcessingReport;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.CanonicalSchemaTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.google.common.base.Function;
import java.util.Map;

public final class SyntaxValidator {
    private final Processor<SchemaHolder, SchemaHolder> processor;

    public SyntaxValidator(ValidationConfiguration cfg) {
        SchemaMap map = new SchemaMap();
        SyntaxProcessor byDefault = new SyntaxProcessor(cfg.getDefaultLibrary());
        map = map.setDefaultProcessor(byDefault);
        Map<JsonRef, Library> libraries = cfg.getLibraries();
        for (Map.Entry<JsonRef, Library> entry : libraries.entrySet()) {
            JsonRef ref = entry.getKey();
            SyntaxProcessor syntaxProcessor = new SyntaxProcessor(entry.getValue());
            map = map.addEntry(ref, syntaxProcessor);
        }
        this.processor = map.getProcessor();
    }

    public boolean schemaIsValid(JsonNode schema) {
        DevNullProcessingReport report = new DevNullProcessingReport();
        return this.getResult(schema, (ProcessingReport)report).isSuccess();
    }

    public ProcessingReport validateSchema(JsonNode schema) {
        ListProcessingReport report = new ListProcessingReport();
        return this.getResult(schema, (ProcessingReport)report).getReport();
    }

    private ProcessingResult<SchemaHolder> getResult(JsonNode schema, ProcessingReport report) {
        SchemaHolder holder = SyntaxValidator.holder(schema);
        return ProcessingResult.uncheckedResult(this.processor, (ProcessingReport)report, (MessageProvider)holder);
    }

    private static SchemaHolder holder(JsonNode node) {
        return new SchemaHolder((SchemaTree)new CanonicalSchemaTree(node));
    }

    private static final class SchemaMap
    extends ProcessorMap<JsonRef, SchemaHolder, SchemaHolder> {
        private SchemaMap() {
        }

        protected Function<SchemaHolder, JsonRef> f() {
            return new Function<SchemaHolder, JsonRef>(){

                public JsonRef apply(SchemaHolder input) {
                    return ((SchemaTree)input.getValue()).getDollarSchema();
                }
            };
        }
    }
}

