/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.validator.helpers.DraftV3TypeKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import java.util.Iterator;

public final class DraftV3TypeValidator
extends DraftV3TypeKeywordValidator {
    public DraftV3TypeValidator(JsonNode digest) {
        super("type", digest);
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        NodeType type = NodeType.getNodeType((JsonNode)instance);
        boolean primitiveOK = this.types.contains(type);
        if (primitiveOK) {
            return;
        }
        ObjectNode fullReport = FACTORY.objectNode();
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        int nrSuccess = 0;
        Iterator i$ = this.schemas.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of((Object)this.keyword, (Object[])new Object[]{index}));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process((ProcessingReport)subReport, (MessageProvider)newData);
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess >= 1) {
            return;
        }
        if (!this.types.isEmpty()) {
            report.error(this.newMsg(data).message((Object)KeywordValidationMessages.TYPE_NO_MATCH).put("expected", (Iterable)this.types).put("found", (Object)type));
        }
        if (!this.schemas.isEmpty()) {
            report.error(this.newMsg(data).message((Object)KeywordValidationMessages.ANYOF_FAIL).put("reports", (JsonNode)fullReport));
        }
    }
}

