/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.load.SchemaLoader;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorMap;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.jsonschema.processors.ref.RefResolver;
import com.github.fge.jsonschema.processors.validation.ValidationChain;
import com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.report.ReportProvider;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.tree.SimpleJsonTree;
import com.google.common.base.Function;
import java.util.Map;

public final class JsonValidator {
    private final Dereferencing dereferencing;
    private final ValidationProcessor processor;
    private final ReportProvider reportProvider;

    JsonValidator(JsonSchemaFactory factory) {
        this.dereferencing = factory.loadingConfiguration.getDereferencing();
        this.processor = new ValidationProcessor(JsonValidator.buildProcessor(factory));
        this.reportProvider = factory.reportProvider;
    }

    private void doValidate(JsonNode schema, JsonNode instance, ProcessingReport report) throws ProcessingException {
        SchemaTree schemaTree = this.dereferencing.newTree(schema);
        SimpleJsonTree tree = new SimpleJsonTree(instance);
        FullData data = new FullData(schemaTree, (JsonTree)tree);
        this.processor.process(report, data);
    }

    public ProcessingReport validate(JsonNode schema, JsonNode instance) throws ProcessingException {
        ProcessingReport report = this.reportProvider.newReport();
        this.doValidate(schema, instance, report);
        return report;
    }

    public ProcessingReport validateUnchecked(JsonNode schema, JsonNode instance) {
        ProcessingReport report = this.reportProvider.newReport();
        try {
            this.doValidate(schema, instance, report);
            return report;
        }
        catch (ProcessingException e) {
            return this.buildUncheckedReport(report, e);
        }
    }

    private ProcessingReport buildUncheckedReport(ProcessingReport report, ProcessingException e) {
        ProcessingReport ret = this.reportProvider.newReport(report.getLogLevel(), LogLevel.NONE);
        ProcessingMessage message = e.getProcessingMessage().setLogLevel(LogLevel.FATAL).put("info", "other messages follow (if any)");
        ListProcessingReport r = new ListProcessingReport(report.getLogLevel(), LogLevel.NONE);
        r.log(LogLevel.FATAL, message);
        try {
            r.mergeWith(report);
            ret.mergeWith((ProcessingReport)r);
        }
        catch (ProcessingException ignored) {
            // empty catch block
        }
        return ret;
    }

    private static Processor<SchemaContext, ValidatorList> buildProcessor(JsonSchemaFactory factory) {
        SchemaLoader loader = new SchemaLoader(factory.loadingConfiguration);
        RefResolver resolver = new RefResolver(loader);
        ValidationConfiguration cfg = factory.validationConfiguration;
        boolean useFormat = cfg.getUseFormat();
        Map<JsonRef, Library> libraries = cfg.getLibraries();
        ValidationChain defaultChain = new ValidationChain(resolver, cfg.getDefaultLibrary(), useFormat);
        ProcessorMap map = new FullChain().setDefaultProcessor(defaultChain);
        for (Map.Entry<JsonRef, Library> entry : libraries.entrySet()) {
            JsonRef ref = entry.getKey();
            ValidationChain chain = new ValidationChain(resolver, entry.getValue(), useFormat);
            map = map.addEntry((Object)ref, (Processor)chain);
        }
        return map.getProcessor();
    }

    private static final class FullChain
    extends ProcessorMap<JsonRef, SchemaContext, ValidatorList> {
        private FullChain() {
        }

        protected Function<SchemaContext, JsonRef> f() {
            return new Function<SchemaContext, JsonRef>(){

                public JsonRef apply(SchemaContext input) {
                    return input.getSchema().getDollarSchema();
                }
            };
        }
    }
}

