/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library.syntax;

import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.draftv4.DefinitionsSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.draftv4.DraftV4DependenciesSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.draftv4.DraftV4ItemsSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.draftv4.DraftV4PropertiesSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.draftv4.DraftV4TypeSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.draftv4.NotSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.draftv4.RequiredSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.helpers.DivisorSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.helpers.PositiveIntegerSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.helpers.SchemaArraySyntaxChecker;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.library.syntax.CommonSyntaxCheckerDictionary;

public final class DraftV4SyntaxCheckerDictionary {
    private static final Dictionary<SyntaxChecker> DICTIONARY;

    public static Dictionary<SyntaxChecker> get() {
        return DICTIONARY;
    }

    private DraftV4SyntaxCheckerDictionary() {
    }

    static {
        DictionaryBuilder builder = Dictionary.newBuilder();
        builder.addAll(CommonSyntaxCheckerDictionary.get());
        String keyword = "items";
        SyntaxChecker checker = DraftV4ItemsSyntaxChecker.getInstance();
        builder.addEntry(keyword, (Object)checker);
        keyword = "multipleOf";
        checker = new DivisorSyntaxChecker(keyword);
        builder.addEntry(keyword, (Object)checker);
        keyword = "minProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.addEntry(keyword, (Object)checker);
        keyword = "maxProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.addEntry(keyword, (Object)checker);
        keyword = "properties";
        checker = DraftV4PropertiesSyntaxChecker.getInstance();
        builder.addEntry(keyword, (Object)checker);
        keyword = "required";
        checker = RequiredSyntaxChecker.getInstance();
        builder.addEntry(keyword, (Object)checker);
        keyword = "dependencies";
        checker = DraftV4DependenciesSyntaxChecker.getInstance();
        builder.addEntry(keyword, (Object)checker);
        keyword = "allOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        builder.addEntry(keyword, (Object)checker);
        keyword = "anyOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        builder.addEntry(keyword, (Object)checker);
        keyword = "oneOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        builder.addEntry(keyword, (Object)checker);
        keyword = "not";
        checker = NotSyntaxChecker.getInstance();
        builder.addEntry(keyword, (Object)checker);
        keyword = "definitions";
        checker = DefinitionsSyntaxChecker.getInstance();
        builder.addEntry(keyword, (Object)checker);
        keyword = "type";
        checker = DraftV4TypeSyntaxChecker.getInstance();
        builder.addEntry(keyword, (Object)checker);
        DICTIONARY = builder.freeze();
    }
}

