/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;

public final class AdditionalItemsValidator
extends AbstractKeywordValidator {
    private final boolean additionalOK;
    private final int itemsSize;

    public AdditionalItemsValidator(JsonNode digest) {
        super("additionalItems");
        this.additionalOK = digest.get(this.keyword).booleanValue();
        this.itemsSize = digest.get("itemsSize").intValue();
    }

    @Override
    public void validate(Processor<FullData, ProcessingReport> processor, ProcessingReport report, FullData data) throws ProcessingException {
        if (this.additionalOK) {
            return;
        }
        int size = data.getInstance().getNode().size();
        if (size > this.itemsSize) {
            report.error(this.newMsg(data).message((Object)KeywordValidationMessages.ADDITIONAL_ITEMS_NOT_ALLOWED).put("allowed", this.itemsSize).put("found", size));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + (this.additionalOK ? "allowed" : this.itemsSize + " max");
    }
}

