/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.RhinoHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class AdditionalPropertiesValidator
extends AbstractKeywordValidator {
    private static final Joiner TOSTRING_JOINER = Joiner.on((String)"; or ");
    private final boolean additionalOK;
    private final Set<String> properties;
    private final Set<String> patternProperties;

    public AdditionalPropertiesValidator(JsonNode digest) {
        super("additionalProperties");
        this.additionalOK = digest.get(this.keyword).booleanValue();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode node : digest.get("properties")) {
            builder.add((Object)node.textValue());
        }
        this.properties = builder.build();
        builder = ImmutableSet.builder();
        for (JsonNode node : digest.get("patternProperties")) {
            builder.add((Object)node.textValue());
        }
        this.patternProperties = builder.build();
    }

    @Override
    public void validate(Processor<FullData, ProcessingReport> processor, ProcessingReport report, FullData data) throws ProcessingException {
        if (this.additionalOK) {
            return;
        }
        JsonNode instance = data.getInstance().getNode();
        HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
        fields.removeAll(this.properties);
        HashSet tmp = Sets.newHashSet();
        for (String field : fields) {
            for (String regex : this.patternProperties) {
                if (!RhinoHelper.regMatch((String)regex, (String)field)) continue;
                tmp.add(field);
            }
        }
        fields.removeAll(tmp);
        if (fields.isEmpty()) {
            return;
        }
        report.error(this.newMsg(data).message((Object)KeywordValidationMessages.ADDITIONAL_PROPERTIES_NOT_ALLOWED).put("unwanted", (Iterable)Ordering.natural().sortedCopy((Iterable)fields)));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.keyword + ": ");
        if (this.additionalOK) {
            return sb.append("allowed").toString();
        }
        sb.append("none");
        if (this.properties.isEmpty() && this.patternProperties.isEmpty()) {
            return sb.toString();
        }
        sb.append(", unless: ");
        LinkedHashSet further = Sets.newLinkedHashSet();
        if (!this.properties.isEmpty()) {
            further.add("one property is any of: " + this.properties);
        }
        if (!this.patternProperties.isEmpty()) {
            further.add("a property matches any regex among: " + this.patternProperties);
        }
        sb.append(TOSTRING_JOINER.join((Iterable)further));
        return sb.toString();
    }
}

