/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.tree;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.BaseSchemaTree;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class CanonicalSchemaTree
extends BaseSchemaTree {
    public CanonicalSchemaTree(JsonNode baseNode) {
        this(JsonRef.emptyRef(), baseNode);
    }

    public CanonicalSchemaTree(JsonRef loadingRef, JsonNode baseNode) {
        super(loadingRef, baseNode, JsonPointer.empty(), false);
    }

    private CanonicalSchemaTree(CanonicalSchemaTree other, JsonPointer newPointer) {
        super((BaseSchemaTree)other, newPointer);
    }

    private CanonicalSchemaTree(CanonicalSchemaTree other, boolean valid) {
        super((BaseSchemaTree)other, valid);
    }

    @Override
    public SchemaTree append(JsonPointer pointer) {
        JsonPointer newPointer = this.pointer.append(pointer);
        return new CanonicalSchemaTree(this, newPointer);
    }

    @Override
    public SchemaTree setPointer(JsonPointer pointer) {
        return new CanonicalSchemaTree(this, pointer);
    }

    @Override
    public boolean containsRef(JsonRef ref) {
        return this.loadingRef.contains(ref);
    }

    @Override
    public JsonPointer matchingPointer(JsonRef ref) {
        if (!ref.isLegal()) {
            return null;
        }
        JsonPointer ptr = ref.getPointer();
        return ((JsonNode)ptr.path((TreeNode)this.baseNode)).isMissingNode() ? null : ptr;
    }

    @Override
    public SchemaTree withValidationStatus(boolean valid) {
        return new CanonicalSchemaTree(this, valid);
    }
}

