/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.tree;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.jsonpointer.TokenResolver;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.JacksonUtils;
import java.util.Iterator;

public abstract class BaseSchemaTree
implements SchemaTree {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    protected final boolean valid;
    protected final JsonNode baseNode;
    protected final JsonPointer pointer;
    private final JsonNode node;
    protected final JsonRef loadingRef;
    private final JsonRef startingRef;
    private final JsonRef currentRef;

    protected BaseSchemaTree(JsonRef loadingRef, JsonNode baseNode, JsonPointer pointer, boolean valid) {
        this.baseNode = baseNode;
        this.pointer = pointer;
        this.node = (JsonNode)pointer.path((TreeNode)baseNode);
        this.loadingRef = loadingRef;
        JsonRef ref = BaseSchemaTree.idFromNode(baseNode);
        this.startingRef = ref == null ? loadingRef : loadingRef.resolve(ref);
        this.currentRef = BaseSchemaTree.nextRef(this.startingRef, pointer, baseNode);
        this.valid = valid;
    }

    protected BaseSchemaTree(BaseSchemaTree other, JsonPointer newPointer) {
        this.baseNode = other.baseNode;
        this.loadingRef = other.loadingRef;
        this.pointer = newPointer;
        this.node = (JsonNode)newPointer.get((TreeNode)this.baseNode);
        this.valid = other.valid;
        this.startingRef = other.startingRef;
        this.currentRef = BaseSchemaTree.nextRef(this.startingRef, newPointer, this.baseNode);
    }

    protected BaseSchemaTree(BaseSchemaTree other, boolean valid) {
        this.baseNode = other.baseNode;
        this.loadingRef = other.loadingRef;
        this.currentRef = other.currentRef;
        this.pointer = other.pointer;
        this.node = other.node;
        this.startingRef = other.startingRef;
        this.valid = valid;
    }

    @Override
    public final JsonNode getBaseNode() {
        return this.baseNode;
    }

    @Override
    public final JsonPointer getPointer() {
        return this.pointer;
    }

    @Override
    public final JsonNode getNode() {
        return this.node;
    }

    @Override
    public final JsonRef resolve(JsonRef other) {
        return this.currentRef.resolve(other);
    }

    @Override
    public final JsonRef getLoadingRef() {
        return this.loadingRef;
    }

    @Override
    public final JsonRef getContext() {
        return this.currentRef;
    }

    @Override
    public final boolean isValid() {
        return this.valid;
    }

    protected static JsonRef idFromNode(JsonNode node) {
        if (!node.path("id").isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(node.get("id").textValue());
        }
        catch (JsonReferenceException ignored) {
            return null;
        }
    }

    private static JsonRef nextRef(JsonRef startingRef, JsonPointer ptr, JsonNode startingNode) {
        TokenResolver resolver;
        JsonRef ret = startingRef;
        JsonNode node = startingNode;
        Iterator i$ = ptr.iterator();
        while (i$.hasNext() && (node = (JsonNode)(resolver = (TokenResolver)i$.next()).get((TreeNode)node)) != null) {
            JsonRef idRef = BaseSchemaTree.idFromNode(node);
            if (idRef == null) continue;
            ret = ret.resolve(idRef);
        }
        return ret;
    }

    public final JsonNode asJson() {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("loadingURI", (JsonNode)FACTORY.textNode(this.loadingRef.toString()));
        ret.put("pointer", (JsonNode)FACTORY.textNode(this.pointer.toString()));
        return ret;
    }

    public final String toString() {
        return "loading URI: " + this.loadingRef + "; current pointer: " + this.pointer + "; resolution context: " + this.currentRef;
    }
}

