/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.load.SchemaLoader;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorChain;
import com.github.fge.jsonschema.processing.ProcessorSelector;
import com.github.fge.jsonschema.processors.data.FullValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.processors.ref.RefResolverProcessor;
import com.github.fge.jsonschema.processors.validation.ValidationChain;
import com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.report.ReportProvider;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.tree.SimpleJsonTree;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;

public final class JsonValidator {
    private final Dereferencing dereferencing;
    private final ValidationProcessor processor;
    private final ReportProvider reportProvider;

    JsonValidator(JsonSchemaFactory factory) {
        this.dereferencing = factory.loadingConfiguration.getDereferencing();
        SchemaLoader loader = new SchemaLoader(factory.loadingConfiguration);
        RefResolverProcessor refResolver = new RefResolverProcessor(loader);
        ProcessorChain chain = ProcessorChain.startWith((Processor)refResolver).chainWith(JsonValidator.buildProcessor(factory));
        this.processor = new ValidationProcessor((Processor<ValidationContext, FullValidationContext>)chain.getProcessor());
        this.reportProvider = factory.reportProvider;
    }

    private void doValidate(JsonNode schema, JsonNode instance, ProcessingReport report) throws ProcessingException {
        SchemaTree schemaTree = this.dereferencing.newTree(schema);
        SimpleJsonTree tree = new SimpleJsonTree(instance);
        ValidationData data = new ValidationData(schemaTree, tree);
        this.processor.process(report, data);
    }

    public ProcessingReport validate(JsonNode schema, JsonNode instance) throws ProcessingException {
        ProcessingReport report = this.reportProvider.newReport();
        this.doValidate(schema, instance, report);
        return report;
    }

    public ProcessingReport validateUnchecked(JsonNode schema, JsonNode instance) {
        ProcessingReport report = this.reportProvider.newReport();
        try {
            this.doValidate(schema, instance, report);
            return report;
        }
        catch (ProcessingException e) {
            return this.buildUncheckedReport(report, e);
        }
    }

    private static Processor<ValidationContext, FullValidationContext> buildProcessor(JsonSchemaFactory factory) {
        ValidationChain chain;
        ValidationConfiguration cfg = factory.validationConfiguration;
        ProcessorSelector selector = new ProcessorSelector();
        Map<JsonRef, Library> libraries = cfg.getLibraries();
        boolean useFormat = cfg.getUseFormat();
        for (Map.Entry<JsonRef, Library> entry : libraries.entrySet()) {
            Predicate<ValidationContext> predicate = JsonValidator.versionTest(entry.getKey());
            chain = new ValidationChain(entry.getValue(), useFormat);
            selector = selector.when(predicate).then((Processor)chain);
        }
        chain = new ValidationChain(cfg.getDefaultLibrary(), useFormat);
        selector = selector.otherwise((Processor)chain);
        return selector.getProcessor();
    }

    private static Predicate<ValidationContext> versionTest(final JsonRef ref) {
        return new Predicate<ValidationContext>(){

            public boolean apply(ValidationContext input) {
                return ref.equals(JsonValidator.extractDollarSchema(input));
            }
        };
    }

    private static JsonRef extractDollarSchema(ValidationContext context) {
        JsonNode schema = context.getSchema().getBaseNode();
        JsonNode node = schema.path("$schema");
        if (!node.isTextual()) {
            return JsonRef.emptyRef();
        }
        try {
            return JsonRef.fromString(node.textValue());
        }
        catch (JsonReferenceException ignored) {
            return JsonRef.emptyRef();
        }
    }

    private ProcessingReport buildUncheckedReport(ProcessingReport report, ProcessingException e) {
        ProcessingReport ret = this.reportProvider.newReport();
        List messages = report.getMessages();
        ProcessingMessage message = e.getProcessingMessage().setLogLevel(LogLevel.FATAL).put("info", "other messages follow (if any)");
        ret.setExceptionThreshold(LogLevel.NONE);
        try {
            ret.log(message);
            if (messages != null) {
                for (ProcessingMessage msg : messages) {
                    ret.log(msg);
                }
            }
        }
        catch (ProcessingException ignored) {
            // empty catch block
        }
        return ret;
    }
}

