/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.schema.SchemaContext;

public final class SchemaNode {
    private final SchemaContext schemaContext;
    private final JsonNode node;
    private final int hashCode;

    public SchemaNode(SchemaContext schemaContext, JsonNode node) {
        this.schemaContext = schemaContext;
        this.node = node;
        this.hashCode = 31 * schemaContext.hashCode() + node.hashCode();
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public String toString() {
        return "locator: " + this.schemaContext.getLocator() + "; schema: " + this.node;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaNode other = (SchemaNode)obj;
        return this.schemaContext.equals(other.schemaContext) && this.node.equals((Object)other.node);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

