/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.metaschema;

import com.github.fge.jsonschema.syntax.DivisorSyntaxChecker;
import com.github.fge.jsonschema.syntax.PositiveIntegerSyntaxChecker;
import com.github.fge.jsonschema.syntax.SchemaOrSchemaArraySyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.syntax.TypeOnlySyntaxChecker;
import com.github.fge.jsonschema.syntax.common.AdditionalSyntaxChecker;
import com.github.fge.jsonschema.syntax.common.EnumSyntaxChecker;
import com.github.fge.jsonschema.syntax.common.ExclusiveMaximumSyntaxChecker;
import com.github.fge.jsonschema.syntax.common.ExclusiveMinimumSyntaxChecker;
import com.github.fge.jsonschema.syntax.common.PatternPropertiesSyntaxChecker;
import com.github.fge.jsonschema.syntax.common.PatternSyntaxChecker;
import com.github.fge.jsonschema.syntax.common.URISyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv3.DraftV3DependenciesSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv3.DraftV3PropertiesSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv3.DraftV3TypeKeywordSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.DefinitionsSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.DraftV4DependenciesSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.DraftV4PropertiesSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.DraftV4TypeSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.NotSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.RequiredSyntaxChecker;
import com.github.fge.jsonschema.syntax.draftv4.SchemaArraySyntaxChecker;
import com.github.fge.jsonschema.syntax.hyperschema.draftv3.ContentEncodingSyntaxChecker;
import com.github.fge.jsonschema.syntax.hyperschema.draftv3.FragmentResolutionSyntaxChecker;
import com.github.fge.jsonschema.syntax.hyperschema.draftv3.LinksSyntaxChecker;
import com.github.fge.jsonschema.syntax.hyperschema.draftv3.MediaTypeSyntaxChecker;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class SyntaxCheckers {
    private static final Map<String, SyntaxChecker> DRAFTV3_CORE;
    private static final Map<String, SyntaxChecker> DRAFTV3_HYPERSCHEMA;
    private static final Map<String, SyntaxChecker> DRAFTV4_CORE;

    private SyntaxCheckers() {
    }

    static Map<String, SyntaxChecker> draftV3Core() {
        return DRAFTV3_CORE;
    }

    static Map<String, SyntaxChecker> draftV3HyperSchema() {
        return DRAFTV3_HYPERSCHEMA;
    }

    static Map<String, SyntaxChecker> draftV4Core() {
        return DRAFTV4_CORE;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String keyword = "additionalItems";
        SyntaxChecker checker = new AdditionalSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "minItems";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "maxItems";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "uniqueItems";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.BOOLEAN, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        keyword = "minimum";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.INTEGER, NodeType.NUMBER);
        builder.put((Object)keyword, (Object)checker);
        keyword = "exclusiveMinimum";
        checker = ExclusiveMinimumSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "maximum";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.INTEGER, NodeType.NUMBER);
        builder.put((Object)keyword, (Object)checker);
        keyword = "exclusiveMaximum";
        checker = ExclusiveMaximumSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "additionalProperties";
        checker = new AdditionalSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "patternProperties";
        checker = PatternPropertiesSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "minLength";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "maxLength";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "pattern";
        checker = PatternSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "$schema";
        checker = new URISyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "$ref";
        checker = new URISyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "id";
        checker = new URISyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "description";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        keyword = "title";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        keyword = "enum";
        checker = EnumSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "format";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.STRING, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        ImmutableMap common = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll((Map)common);
        keyword = "items";
        checker = new SchemaOrSchemaArraySyntaxChecker(keyword, true);
        builder.put((Object)keyword, (Object)checker);
        keyword = "divisibleBy";
        checker = new DivisorSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "properties";
        checker = DraftV3PropertiesSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "dependencies";
        checker = DraftV3DependenciesSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "extends";
        checker = new SchemaOrSchemaArraySyntaxChecker(keyword, true);
        builder.put((Object)keyword, (Object)checker);
        keyword = "type";
        checker = new DraftV3TypeKeywordSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "disallow";
        checker = new DraftV3TypeKeywordSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        DRAFTV3_CORE = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll(DRAFTV3_CORE);
        keyword = "fragmentResolution";
        checker = FragmentResolutionSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "readonly";
        checker = new TypeOnlySyntaxChecker(keyword, NodeType.BOOLEAN, new NodeType[0]);
        builder.put((Object)keyword, (Object)checker);
        keyword = "contentEncoding";
        checker = ContentEncodingSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "pathStart";
        checker = new URISyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "mediaType";
        checker = MediaTypeSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "links";
        checker = LinksSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        DRAFTV3_HYPERSCHEMA = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll((Map)common);
        keyword = "items";
        checker = new SchemaOrSchemaArraySyntaxChecker(keyword, false);
        builder.put((Object)keyword, (Object)checker);
        keyword = "multipleOf";
        checker = new DivisorSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "minProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "maxProperties";
        checker = new PositiveIntegerSyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "properties";
        checker = DraftV4PropertiesSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "required";
        checker = RequiredSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "dependencies";
        checker = DraftV4DependenciesSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "anyOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "allOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "oneOf";
        checker = new SchemaArraySyntaxChecker(keyword);
        builder.put((Object)keyword, (Object)checker);
        keyword = "not";
        checker = NotSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "type";
        checker = DraftV4TypeSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        keyword = "definitions";
        checker = DefinitionsSyntaxChecker.getInstance();
        builder.put((Object)keyword, (Object)checker);
        DRAFTV4_CORE = builder.build();
    }
}

