/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.net.MediaType;

public final class MediaTypeFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new MediaTypeFormatAttribute();

    private MediaTypeFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        try {
            MediaType.parse((String)value.textValue());
        }
        catch (IllegalArgumentException ignored) {
            Message.Builder msg = MediaTypeFormatAttribute.newMsg(fmt).addInfo("value", value).setMessage("value is not a valid media type");
            report.addMessage(msg.build());
        }
    }
}

