/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.processing.JsonSchemaContext;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.ProcessingMessage;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ref.SchemaLoader;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;

public final class RefResolverProcessor
implements Processor<JsonSchemaTree, JsonSchemaContext> {
    private final SchemaLoader loader;

    public RefResolverProcessor(SchemaLoader loader) {
        this.loader = loader;
    }

    @Override
    public JsonSchemaTree process(JsonSchemaContext context) throws ProcessingException {
        JsonNode node;
        JsonRef ref;
        ProcessingMessage msg = context.newMessage();
        LinkedHashSet refs = Sets.newLinkedHashSet();
        JsonSchemaTree tree = context.getSchemaTree().copy();
        while ((ref = RefResolverProcessor.nodeAsRef(node = tree.getCurrentNode())) != null) {
            JsonPointer ptr;
            if (!refs.add(ref = tree.resolve(ref))) {
                msg.msg("JSON Reference loop detected").put("ref", ref).put("path", refs);
                throw new ProcessingException(msg);
            }
            if (!tree.containsRef(ref)) {
                tree = this.loader.get(ref.getLocator());
            }
            if ((ptr = tree.matchingPointer(ref)) == null) {
                msg.msg("unresolvable JSON Reference").put("ref", ref);
                throw new ProcessingException(msg);
            }
            tree.setPointer(ptr);
        }
        return tree;
    }

    private static JsonRef nodeAsRef(JsonNode node) {
        JsonNode refNode = node.path("$ref");
        if (!refNode.isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(refNode.textValue());
        }
        catch (JsonSchemaException ignored) {
            return null;
        }
    }
}

