/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.github.fge.jsonschema.keyword.NumericKeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import java.math.BigDecimal;

public final class MaximumKeywordValidator
extends NumericKeywordValidator {
    private final boolean exclusive;

    public MaximumKeywordValidator(JsonNode schema) {
        super("maximum", schema);
        this.exclusive = schema.path("exclusiveMaximum").asBoolean(false);
    }

    @Override
    protected void validateLong(ValidationReport report, JsonNode instance) {
        long longValue;
        long instanceValue = instance.longValue();
        if (instanceValue < (longValue = this.number.longValue())) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo(this.keyword, this.number).addInfo("found", instance);
        if (instanceValue > longValue) {
            msg.setMessage("number is greater than the required maximum");
            report.addMessage(msg.build());
            return;
        }
        if (!this.exclusive) {
            return;
        }
        msg.setMessage("number is not strictly lower than the required maximum").addInfo("exclusiveMaximum", (JsonNode)BooleanNode.TRUE);
        report.addMessage(msg.build());
    }

    @Override
    protected void validateDecimal(ValidationReport report, JsonNode instance) {
        BigDecimal decimalValue;
        BigDecimal instanceValue = instance.decimalValue();
        int cmp = instanceValue.compareTo(decimalValue = this.number.decimalValue());
        if (cmp < 0) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo(this.keyword, this.number).addInfo("found", instance);
        if (cmp > 0) {
            msg.setMessage("number is greater than the required maximum");
            report.addMessage(msg.build());
            return;
        }
        if (!this.exclusive) {
            return;
        }
        msg.setMessage("number is not strictly lower than the required maximum").addInfo("exclusiveMaximum", (JsonNode)BooleanNode.TRUE);
        report.addMessage(msg.build());
    }
}

