/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import java.net.URI;
import java.net.URISyntaxException;

public final class URIFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new URIFormatAttribute();

    private URIFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        try {
            new URI(value.textValue());
        }
        catch (URISyntaxException ignored) {
            Message.Builder msg = URIFormatAttribute.newMsg(fmt).addInfo("value", value).setMessage("string is not a valid URI");
            report.addMessage(msg.build());
        }
    }
}

