/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Domain;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;
import java.util.Collections;
import java.util.EnumSet;

public abstract class KeywordValidator {
    protected final String keyword;
    private final EnumSet<NodeType> instanceTypes = EnumSet.noneOf(NodeType.class);

    protected KeywordValidator(String keyword, NodeType ... types) {
        this.keyword = keyword;
        Collections.addAll(this.instanceTypes, types);
    }

    public final void validateInstance(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (this.instanceTypes.contains((Object)NodeType.getNodeType(instance))) {
            this.validate(context, report, instance);
        }
    }

    protected abstract void validate(ValidationContext var1, ValidationReport var2, JsonNode var3);

    protected final Message.Builder newMsg() {
        return Domain.VALIDATION.newMessage().setKeyword(this.keyword);
    }

    public boolean alwaysTrue() {
        return false;
    }

    public abstract String toString();
}

