/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import java.math.BigInteger;

public final class UnixEpochFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new UnixEpochFormatAttribute();
    private static final int EPOCH_BITLENGTH = 31;
    private static final BigInteger ONE_THOUSAND = new BigInteger("1000");

    private UnixEpochFormatAttribute() {
        super(NodeType.INTEGER, NodeType.NUMBER);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        BigInteger epoch = value.bigIntegerValue();
        if (epoch.signum() == -1) {
            Message.Builder msg = UnixEpochFormatAttribute.newMsg(fmt).setMessage("epoch cannot be negative").addInfo("value", value);
            report.addMessage(msg.build());
            return;
        }
        if ((epoch = epoch.divide(ONE_THOUSAND)).bitLength() > 31) {
            Message.Builder msg = UnixEpochFormatAttribute.newMsg(fmt).setMessage("epoch time would overflow").addInfo("value", value);
            report.addMessage(msg.build());
        }
    }
}

