/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.net.InetAddresses;

public final class IPV6FormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new IPV6FormatAttribute();
    private static final int IPV6_LENGTH = 16;

    private IPV6FormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        String ipaddr = value.textValue();
        if (InetAddresses.isInetAddress((String)ipaddr) && InetAddresses.forString((String)ipaddr).getAddress().length == 16) {
            return;
        }
        Message.Builder msg = IPV6FormatAttribute.newMsg(fmt).setMessage("string is not a valid IPv6 address").addInfo("value", value);
        report.addMessage(msg.build());
    }
}

