/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.schema.SchemaContainer;

public final class SchemaNode {
    private final SchemaContainer container;
    private final JsonNode node;
    private final int hashCode;

    public SchemaNode(SchemaContainer container, JsonNode node) {
        this.container = container;
        this.node = node;
        this.hashCode = 31 * container.hashCode() + node.hashCode();
    }

    public SchemaContainer getContainer() {
        return this.container;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public String toString() {
        return "locator: " + this.container.getLocator() + "; schema: " + this.node;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaNode other = (SchemaNode)obj;
        return this.container.equals(other.container) && this.node.equals((Object)other.node);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

