/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.uri;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eel.kitchen.jsonschema.uri.URIDownloader;

public final class ResourceURIDownloader
implements URIDownloader {
    private static final Class<ResourceURIDownloader> myself = ResourceURIDownloader.class;
    private static final URIDownloader INSTANCE = new ResourceURIDownloader();

    private ResourceURIDownloader() {
    }

    public static URIDownloader getInstance() {
        return INSTANCE;
    }

    @Override
    public InputStream fetch(URI source) throws IOException {
        String resource = source.getPath();
        InputStream in = myself.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("resource " + resource + " not found");
        }
        return in;
    }
}

