/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.metaschema;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistries;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistry;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.JsonLoader;

public enum BuiltinSchemas {
    DRAFTV3_CORE("http://json-schema.org/draft-03/schema#", "/draftv3/schema", "draft v3 core schema", KeywordRegistries.draftV3Core()),
    DRAFTV4_CORE("http://json-schema.org/draft-04/schema#", "/draftv4/schema", "draft v4 core schema", KeywordRegistries.draftV4Core()),
    DRAFTV3_LINKS("http://json-schema.org/draft-03/links#", "/draftv3/links", "draft v3 link description object (LDO) schema", KeywordRegistries.draftV3HyperSchema()),
    DRAFTV3_HYPERSCHEMA("http://json-schema.org/draft-03/hyper-schema#", "/draftv3/hyper-schema", "draft v3 hyper schema", KeywordRegistries.draftV3HyperSchema());

    private final JsonRef locator;
    private final JsonNode rawSchema;
    private final String desc;
    final Map<String, SyntaxChecker> checkers;
    final Map<String, Class<? extends KeywordValidator>> validators;
    final Map<String, FormatAttribute> formatAttributes;

    private BuiltinSchemas(String uri, String resource, String desc, KeywordRegistry registry) {
        try {
            this.locator = JsonRef.fromString(uri);
            this.rawSchema = JsonLoader.fromResource(resource);
        }
        catch (JsonSchemaException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        this.desc = desc;
        this.checkers = registry.getSyntaxCheckers();
        this.validators = registry.getValidators();
        this.formatAttributes = registry.getFormatAttributes();
    }

    public static BuiltinSchemas byDefault() {
        return DRAFTV3_HYPERSCHEMA;
    }

    public URI getURI() {
        return this.locator.toURI();
    }

    public JsonNode getRawSchema() {
        return this.rawSchema;
    }

    public String toString() {
        return this.desc + " (" + this.locator + ')';
    }
}

