/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.MediaType;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class MediaTypeFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new MediaTypeFormatAttribute();

    private MediaTypeFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        try {
            MediaType.parse((String)value.textValue());
        }
        catch (IllegalArgumentException ignored) {
            Message.Builder msg = MediaTypeFormatAttribute.newMsg(fmt).addInfo("value", value).setMessage("value is not a valid media type");
            report.addMessage(msg.build());
        }
    }
}

