/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class JacksonUtils {
    private static final JsonNode EMPTY_SCHEMA = JsonNodeFactory.instance.objectNode();

    private JacksonUtils() {
    }

    public static Map<String, JsonNode> nodeToMap(JsonNode node) {
        HashMap ret = Maps.newHashMap();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static SortedMap<String, JsonNode> nodeToTreeMap(JsonNode node) {
        TreeMap ret = Maps.newTreeMap();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static Set<String> fieldNames(JsonNode node) {
        HashSet<String> ret = new HashSet<String>(node.size());
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            ret.add((String)iterator.next());
        }
        return ret;
    }

    public static JsonNode emptySchema() {
        return EMPTY_SCHEMA;
    }
}

