/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public class PositiveIntegerSyntaxChecker
extends SimpleSyntaxChecker {
    public PositiveIntegerSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, new NodeType[0]);
    }

    @Override
    final void checkValue(ValidationMessage.Builder msg, List<ValidationMessage> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        msg.addInfo("found", node);
        if (!node.canConvertToInt()) {
            msg.setMessage("integer value is too large").addInfo("max", Integer.MAX_VALUE);
            messages.add(msg.build());
            return;
        }
        if (node.intValue() >= 0) {
            return;
        }
        messages.add(msg.setMessage("value cannot be negative").build());
    }
}

