/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class FormatKeywordValidator
extends KeywordValidator {
    private final String fmt;

    public FormatKeywordValidator(JsonNode schema) {
        super("format", NodeType.values());
        this.fmt = schema.get(this.keyword).textValue();
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        FormatSpecifier specifier = context.getFormat(this.fmt);
        if (specifier == null) {
            return;
        }
        specifier.validate(this.fmt, context, report, instance);
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.fmt;
    }
}

