/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.eel.kitchen.jsonschema.keyword.NumericKeywordValidator;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;

public final class DivisibleByKeywordValidator
extends NumericKeywordValidator {
    public DivisibleByKeywordValidator(JsonNode schema) {
        super("divisibleBy", schema);
    }

    @Override
    protected void validateLong(ValidationReport report, JsonNode instance) {
        long longValue;
        long instanceValue = instance.longValue();
        long remainder = instanceValue % (longValue = this.number.longValue());
        if (remainder == 0L) {
            return;
        }
        ValidationMessage.Builder msg = this.newMsg().setMessage("number is not a multiple of divisibleBy").addInfo("value", instance).addInfo("divisor", this.number);
        report.addMessage(msg.build());
    }

    @Override
    protected void validateDecimal(ValidationReport report, JsonNode instance) {
        BigDecimal decimalValue;
        BigDecimal instanceValue = instance.decimalValue();
        BigDecimal remainder = instanceValue.remainder(decimalValue = this.number.decimalValue());
        if (remainder.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        ValidationMessage.Builder msg = this.newMsg().setMessage("number is not a multiple of divisibleBy").addInfo("value", instance).addInfo("divisor", this.number);
        report.addMessage(msg.build());
    }
}

