/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.ValidationFeature;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class EmailFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new EmailFormatSpecifier();

    private EmailFormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationContext ctx, ValidationReport report, JsonNode instance) {
        boolean strictRFC = ctx.hasFeature(ValidationFeature.STRICT_RFC_CONFORMANCE);
        try {
            new InternetAddress(instance.textValue(), !strictRFC);
        }
        catch (AddressException ignored) {
            ValidationMessage.Builder msg = EmailFormatSpecifier.newMsg(fmt).setMessage("string is not a valid email address").addInfo("value", instance);
            report.addMessage(msg.build());
        }
    }
}

