/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.google.common.collect.Iterables;

public final class RemoveOperation
extends JsonPatchOperation {
    @JsonCreator
    public RemoveOperation(@JsonProperty(value="path") JsonPointer path) {
        super(path);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return MissingNode.getInstance();
        }
        if (((JsonNode)this.path.path((TreeNode)node)).isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        JsonNode ret = node.deepCopy();
        JsonNode parentNode = (JsonNode)this.path.parent().get((TreeNode)ret);
        String raw = ((TokenResolver)Iterables.getLast((Iterable)this.path)).getToken().getRaw();
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(raw);
        } else {
            ((ArrayNode)parentNode).remove(Integer.parseInt(raw));
        }
        return ret;
    }

    @Override
    public String toString() {
        return "remove: " + super.toString();
    }
}

