/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.AddOperation;
import com.github.fge.jsonpatch.DualPathOperation;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.RemoveOperation;

public final class MoveOperation
extends DualPathOperation {
    @JsonCreator
    public MoveOperation(@JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path) {
        super(from, path);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.from.equals((Object)this.path)) {
            return node.deepCopy();
        }
        JsonNode movedNode = (JsonNode)this.from.path((TreeNode)node);
        if (movedNode.isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        RemoveOperation remove = new RemoveOperation(this.from);
        AddOperation add = new AddOperation(this.path, movedNode);
        return ((JsonPatchOperation)add).apply(((JsonPatchOperation)remove).apply(node));
    }

    @Override
    public String toString() {
        return "move: " + super.toString();
    }
}

