/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class JsonDiff {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    private JsonDiff() {
    }

    public static JsonNode asJson(JsonNode first, JsonNode second) {
        ArrayList diffs = Lists.newArrayList();
        JsonDiff.generateDiffs(diffs, JsonPointer.empty(), first, second);
        JsonDiff.factorizeDiffs(diffs);
        ArrayNode patch = FACTORY.arrayNode();
        for (Diff diff : diffs) {
            patch.add(diff.asJsonPatch());
        }
        return patch;
    }

    private static void generateDiffs(List<Diff> diffs, JsonPointer path, JsonNode first, JsonNode second) {
        NodeType secondType;
        if (EQUIVALENCE.equivalent((Object)first, (Object)second)) {
            return;
        }
        NodeType firstType = NodeType.getNodeType((JsonNode)first);
        if (firstType != (secondType = NodeType.getNodeType((JsonNode)second)) || !first.isContainerNode()) {
            diffs.add(new Diff(DiffOperation.REPLACE, path, second.deepCopy()));
            return;
        }
        if (firstType == NodeType.OBJECT) {
            JsonDiff.generateObjectDiffs(diffs, path, first, second);
        } else {
            JsonDiff.generateArrayDiffs(diffs, path, first, second);
        }
    }

    private static void generateObjectDiffs(List<Diff> diffs, JsonPointer path, JsonNode first, JsonNode second) {
        ArrayList inFirst = Lists.newArrayList((Iterator)first.fieldNames());
        ArrayList inSecond = Lists.newArrayList((Iterator)second.fieldNames());
        ArrayList fields = Lists.newArrayList((Iterable)inSecond);
        fields.removeAll(inFirst);
        for (String added : fields) {
            diffs.add(new Diff(DiffOperation.ADD, path.append(added), second.get(added).deepCopy()));
        }
        fields = Lists.newArrayList((Iterable)inFirst);
        fields.removeAll(inSecond);
        for (String removed : fields) {
            diffs.add(new Diff(DiffOperation.REMOVE, path.append(removed), first.get(removed).deepCopy()));
        }
        fields = Lists.newArrayList((Iterable)inFirst);
        fields.retainAll(inSecond);
        for (String common : fields) {
            JsonDiff.generateDiffs(diffs, path.append(common), first.get(common), second.get(common));
        }
    }

    private static void generateArrayDiffs(List<Diff> diffs, JsonPointer path, JsonNode first, JsonNode second) {
        List<JsonNode> lcs = JsonDiff.getLCSDiffs(first, second);
        int firstSize = first.size();
        int secondSize = second.size();
        int lcsSize = lcs.size();
        int firstIndex = 0;
        int secondIndex = 0;
        int lcsIndex = 0;
        while (firstIndex < firstSize || secondIndex < secondSize) {
            JsonNode lcsElement;
            JsonNode firstElement = first.get(firstIndex);
            JsonNode secondElement = second.get(secondIndex);
            JsonNode jsonNode = lcsElement = lcsIndex < lcsSize ? lcs.get(lcsIndex) : null;
            if (firstElement == null) {
                diffs.add(new Diff(DiffOperation.ADD, path, firstIndex, -1, second.get(secondIndex).deepCopy()));
                ++secondIndex;
                continue;
            }
            if (EQUIVALENCE.equivalent((Object)firstElement, (Object)lcsElement)) {
                if (EQUIVALENCE.equivalent((Object)firstElement, (Object)secondElement)) {
                    ++firstIndex;
                    ++secondIndex;
                    ++lcsIndex;
                    continue;
                }
                diffs.add(new Diff(DiffOperation.ADD, path, firstIndex, secondIndex, second.get(secondIndex).deepCopy()));
                ++secondIndex;
                continue;
            }
            if (secondElement != null && !EQUIVALENCE.equivalent((Object)secondElement, (Object)lcsElement)) {
                if (firstIndex == secondIndex) {
                    JsonDiff.generateDiffs(diffs, path.append(firstIndex), firstElement, secondElement);
                } else {
                    diffs.add(new Diff(DiffOperation.REPLACE, path, firstIndex, secondIndex, second.get(secondIndex).deepCopy()));
                }
                ++firstIndex;
                ++secondIndex;
                continue;
            }
            diffs.add(new Diff(DiffOperation.REMOVE, path, firstIndex, secondIndex, first.get(firstIndex).deepCopy()));
            ++firstIndex;
        }
    }

    private static List<JsonNode> getLCSDiffs(JsonNode first, JsonNode second) {
        int i;
        int firstSize = first.size();
        int secondSize = second.size();
        int minSize = Math.min(firstSize, secondSize);
        int offset = 0;
        int trim = 0;
        for (int index = 0; index < minSize && EQUIVALENCE.equivalent((Object)first.get(index), (Object)second.get(index)); ++index) {
            ++offset;
        }
        int i2 = firstSize - 1;
        for (int j = secondSize - 1; i2 > offset && j > offset && EQUIVALENCE.equivalent((Object)first.get(i2), (Object)second.get(j)); --i2, --j) {
            ++trim;
        }
        List<JsonNode> lcs = Lists.newArrayList();
        if (offset < minSize) {
            int firstLimit = firstSize - offset - trim;
            int secondLimit = secondSize - offset - trim;
            int[][] lengths = new int[firstLimit + 1][secondLimit + 1];
            for (int i3 = 0; i3 < firstLimit; ++i3) {
                for (int j = 0; j < secondLimit; ++j) {
                    JsonNode secondNode;
                    int newLength;
                    JsonNode firstNode = first.get(i3 + offset);
                    lengths[i3 + 1][j + 1] = newLength = EQUIVALENCE.equivalent((Object)firstNode, (Object)(secondNode = second.get(j + offset))) ? lengths[i3][j] + 1 : Math.max(lengths[i3 + 1][j], lengths[i3][j + 1]);
                }
            }
            int x = firstLimit;
            int y = secondLimit;
            while (x > 0 && y > 0) {
                if (lengths[x][y] == lengths[x - 1][y]) {
                    --x;
                    continue;
                }
                if (lengths[x][y] == lengths[x][y - 1]) {
                    --y;
                    continue;
                }
                lcs.add(first.get(x - 1 + offset));
                --x;
                --y;
            }
            lcs = Lists.reverse((List)lcs);
        }
        for (i = 0; i < offset; ++i) {
            lcs.add(0, first.get(i));
        }
        for (i = firstSize - trim; i < firstSize; ++i) {
            lcs.add(first.get(i));
        }
        return lcs;
    }

    private static void factorizeDiffs(List<Diff> diffs) {
        Diff removeDiff;
        int diffsSize = diffs.size();
        block0: for (int addDiffIndex = 0; addDiffIndex < diffsSize; ++addDiffIndex) {
            Diff addDiff = diffs.get(addDiffIndex);
            if (addDiff.operation != DiffOperation.ADD) continue;
            for (int removeDiffIndex = 0; removeDiffIndex < diffsSize; ++removeDiffIndex) {
                removeDiff = diffs.get(removeDiffIndex);
                if (removeDiff.operation != DiffOperation.REMOVE || !EQUIVALENCE.equivalent((Object)removeDiff.value, (Object)addDiff.value)) continue;
                addDiff.pairedDiff = removeDiff;
                addDiff.firstOfPair = addDiffIndex < removeDiffIndex;
                removeDiff.pairedDiff = addDiff;
                removeDiff.firstOfPair = removeDiffIndex < addDiffIndex;
                continue block0;
            }
        }
        ArrayList deferredArrayRemoves = Lists.newArrayList();
        ArrayList advancedArrayRemoves = Lists.newArrayList();
        Iterator<Diff> diffIter = diffs.iterator();
        while (diffIter.hasNext()) {
            Diff diff = diffIter.next();
            if (diff.operation == DiffOperation.REMOVE && diff.pairedDiff != null) {
                if (diff.arrayPath != null && diff.firstOfPair) {
                    deferredArrayRemoves.add(diff);
                }
                diffIter.remove();
                continue;
            }
            if (diff.operation == DiffOperation.ADD && diff.pairedDiff != null) {
                int removeIndex;
                removeDiff = diff.pairedDiff;
                diff.operation = DiffOperation.MOVE;
                diff.pairedDiff = null;
                if (removeDiff.arrayPath == null) {
                    diff.fromPath = removeDiff.path;
                } else if (diff.firstOfPair) {
                    removeIndex = removeDiff.firstArrayIndex;
                    removeIndex = JsonDiff.adjustFirstArrayIndex(advancedArrayRemoves, removeDiff.arrayPath, removeIndex);
                    if (removeDiff.arrayPath.equals((Object)diff.arrayPath)) {
                        int moveSecondArrayIndex = JsonDiff.adjustSecondArrayIndex(deferredArrayRemoves, diff.arrayPath, diff.secondArrayIndex);
                        int moveFirstArrayIndex = JsonDiff.adjustFirstArrayIndex(advancedArrayRemoves, diff.arrayPath, diff.firstArrayIndex);
                        removeIndex += moveSecondArrayIndex - moveFirstArrayIndex;
                    }
                    diff.fromPath = removeDiff.arrayPath.append(removeIndex);
                    advancedArrayRemoves.add(removeDiff);
                } else {
                    deferredArrayRemoves.remove(removeDiff);
                    removeIndex = removeDiff.secondArrayIndex;
                    removeIndex = JsonDiff.adjustSecondArrayIndex(deferredArrayRemoves, removeDiff.arrayPath, removeIndex);
                    diff.fromPath = removeDiff.arrayPath.append(removeIndex);
                }
            }
            if (diff.arrayPath == null) continue;
            diff.secondArrayIndex = JsonDiff.adjustSecondArrayIndex(deferredArrayRemoves, diff.arrayPath, diff.secondArrayIndex);
        }
        ArrayList addDiffs = Lists.newArrayList();
        for (Diff diff : diffs) {
            if (diff.operation != DiffOperation.ADD || diff.value.size() == 0) continue;
            Diff addDiff = null;
            for (Diff testAddDiff : addDiffs) {
                if (!EQUIVALENCE.equivalent((Object)diff.value, (Object)testAddDiff.value)) continue;
                addDiff = testAddDiff;
                break;
            }
            if (addDiff == null) {
                if (diff.arrayPath != null && diff.secondArrayIndex == -1) continue;
                addDiffs.add(diff);
                continue;
            }
            diff.operation = DiffOperation.COPY;
            diff.fromPath = addDiff.arrayPath != null ? addDiff.getSecondArrayPath() : addDiff.path;
        }
    }

    private static int adjustFirstArrayIndex(List<Diff> advancedArrayRemoves, JsonPointer arrayPath, int arrayIndex) {
        if (arrayIndex == -1) {
            return arrayIndex;
        }
        int arrayRemoves = 0;
        for (Diff advancedArrayRemove : advancedArrayRemoves) {
            if (!arrayPath.equals((Object)advancedArrayRemove.arrayPath) || arrayIndex <= advancedArrayRemove.firstArrayIndex) continue;
            ++arrayRemoves;
        }
        return arrayIndex - arrayRemoves;
    }

    private static int adjustSecondArrayIndex(List<Diff> deferredArrayRemoves, JsonPointer arrayPath, int arrayIndex) {
        if (arrayIndex == -1) {
            return arrayIndex;
        }
        int arrayRemoves = 0;
        for (Diff deferredArrayRemove : deferredArrayRemoves) {
            if (!arrayPath.equals((Object)deferredArrayRemove.arrayPath) || arrayIndex < deferredArrayRemove.secondArrayIndex) continue;
            ++arrayRemoves;
        }
        return arrayIndex + arrayRemoves;
    }

    private static final class Diff {
        private DiffOperation operation;
        private JsonPointer path;
        private JsonPointer arrayPath;
        private int firstArrayIndex;
        private int secondArrayIndex;
        private final JsonNode value;
        private JsonPointer fromPath;
        private Diff pairedDiff;
        private boolean firstOfPair;

        private Diff(DiffOperation operation, JsonPointer path, JsonNode value) {
            this.operation = operation;
            this.path = path;
            this.value = value;
        }

        private Diff(DiffOperation operation, JsonPointer arrayPath, int firstArrayIndex, int secondArrayIndex, JsonNode value) {
            this.operation = operation;
            this.arrayPath = arrayPath;
            this.firstArrayIndex = firstArrayIndex;
            this.secondArrayIndex = secondArrayIndex;
            this.value = value;
        }

        private JsonNode asJsonPatch() {
            JsonPointer ptr = this.arrayPath != null ? this.getSecondArrayPath() : this.path;
            ObjectNode patch = this.operation.newOp(ptr);
            if (this.operation == DiffOperation.REMOVE) {
                return patch;
            }
            if (this.operation == DiffOperation.MOVE || this.operation == DiffOperation.COPY) {
                patch.put("from", this.fromPath.toString());
            } else {
                patch.put("value", this.value);
            }
            return patch;
        }

        private JsonPointer getFirstArrayPath() {
            return this.arrayPath.append(this.firstArrayIndex);
        }

        private JsonPointer getSecondArrayPath() {
            if (this.secondArrayIndex != -1) {
                return this.arrayPath.append(this.secondArrayIndex);
            }
            return this.arrayPath.append("-");
        }

        public String toString() {
            return this.asJsonPatch().toString();
        }
    }

    private static enum DiffOperation {
        ADD("add"),
        REMOVE("remove"),
        REPLACE("replace"),
        MOVE("move"),
        COPY("copy");

        private final String opName;

        private DiffOperation(String opName) {
            this.opName = opName;
        }

        private ObjectNode newOp(JsonPointer ptr) {
            ObjectNode ret = FACTORY.objectNode();
            ret.put("op", this.opName);
            ret.put("path", ptr.toString());
            return ret;
        }

        public String toString() {
            return this.opName;
        }
    }
}

