/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.matchers.wrap.VarFramingMatcher;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.support.Var;
import com.github.fge.grappa.transform.CodeBlock;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;

public final class VarFramingGenerator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        return !method.getLocalVarVariables().isEmpty();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        CodeBlock block = CodeBlock.newCodeBlock();
        block.newobj(CodegenUtils.p(VarFramingMatcher.class)).dup_x1().swap();
        VarFramingGenerator.createVarFieldArray(block, method);
        block.invokespecial(CodegenUtils.p(VarFramingMatcher.class), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{Rule.class, Var[].class}));
        instructions.insertBefore(ret, block.getInstructionList());
        method.setBodyRewritten();
    }

    private static void createVarFieldArray(CodeBlock block, RuleMethod method) {
        int count = method.getLocalVarVariables().size();
        block.bipush(count).anewarray(CodegenUtils.p(Var.class));
        for (int i = 0; i < count; ++i) {
            LocalVariableNode var = method.getLocalVarVariables().get(i);
            String varName = method.name + ':' + var.name;
            block.dup().bipush(i).aload(var.index).dup().ldc(varName).invokevirtual(CodegenUtils.p(Var.class), "setName", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{String.class})).aastore();
        }
    }
}

