/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;

public final class ReturnInstructionUnifier
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        return method.getNumberOfReturns() > 1;
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        AbstractInsnNode current = method.instructions.getLast();
        while (current.getOpcode() != 176) {
            current = current.getPrevious();
        }
        LabelNode lastReturnLabel = new LabelNode();
        method.instructions.insertBefore(current, (AbstractInsnNode)lastReturnLabel);
        while ((current = current.getPrevious()) != null) {
            if (current.getOpcode() != 176) continue;
            JumpInsnNode insn = new JumpInsnNode(167, lastReturnLabel);
            method.instructions.set(current, (AbstractInsnNode)insn);
            current = insn;
        }
    }
}

