/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.hash;

import com.github.fge.grappa.transform.base.InstructionGroup;
import com.github.fge.grappa.transform.hash.FieldNodeFunnel;
import com.github.fge.grappa.transform.hash.LabelListFunnel;
import com.github.fge.grappa.transform.hash.LdcInsnFunnel;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.FieldNode;

@NotThreadSafe
public final class InstructionGroupHasher
extends MethodVisitor {
    private static final BaseEncoding BASE_ENCODING = BaseEncoding.base32Hex();
    private static final HashFunction SHA1 = Hashing.sha1();
    private final String className;
    private final InstructionGroup group;
    private final Hasher hasher;
    private final LabelListFunnel labelFunnel = new LabelListFunnel();

    public static void hash(@Nonnull InstructionGroup group, @Nonnull String className) {
        InstructionGroupHasher groupHasher = new InstructionGroupHasher(group, className);
        String name = groupHasher.hashAndGetName();
        group.setName(name);
    }

    private InstructionGroupHasher(@Nonnull InstructionGroup group, @Nonnull String className) {
        super(327680);
        this.group = Objects.requireNonNull(group);
        this.className = Objects.requireNonNull(className);
        this.hasher = SHA1.newHasher();
    }

    private String hashAndGetName() {
        this.group.getInstructions().accept((MethodVisitor)this);
        for (FieldNode node : this.group.getFields()) {
            this.hasher.putObject((Object)node, (Funnel)FieldNodeFunnel.INSTANCE);
        }
        byte[] hash = new byte[10];
        this.hasher.hash().writeBytesTo(hash, 0, 10);
        String prefix = this.group.getRoot().isActionRoot() ? "Action$" : "VarInit$";
        return prefix + BASE_ENCODING.encode(hash);
    }

    public void visitInsn(int opcode) {
        this.hasher.putInt(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.hasher.putInt(opcode).putInt(operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.hasher.putInt(opcode).putInt(var);
        if (opcode == 25 && var == 0) {
            this.hasher.putUnencodedChars((CharSequence)this.className);
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        this.hasher.putInt(opcode).putUnencodedChars((CharSequence)type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.hasher.putInt(opcode).putUnencodedChars((CharSequence)owner).putUnencodedChars((CharSequence)name).putUnencodedChars((CharSequence)desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.hasher.putInt(opcode).putUnencodedChars((CharSequence)owner).putUnencodedChars((CharSequence)name).putUnencodedChars((CharSequence)desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.hasher.putInt(opcode).putObject((Object)label, (Funnel)this.labelFunnel);
    }

    public void visitLabel(Label label) {
        this.hasher.putObject((Object)label, (Funnel)this.labelFunnel);
    }

    public void visitLdcInsn(Object cst) {
        this.hasher.putObject(cst, (Funnel)LdcInsnFunnel.INSTANCE);
    }

    public void visitIincInsn(int var, int increment) {
        this.hasher.putInt(var).putInt(increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.hasher.putInt(min).putInt(max).putObject((Object)dflt, (Funnel)this.labelFunnel);
        for (Label label : labels) {
            this.hasher.putObject((Object)label, (Funnel)this.labelFunnel);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.hasher.putObject((Object)dflt, (Funnel)this.labelFunnel);
        for (int i = 0; i < keys.length; ++i) {
            this.hasher.putInt(keys[i]).putObject((Object)labels[i], (Funnel)this.labelFunnel);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.hasher.putUnencodedChars((CharSequence)desc).putInt(dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.hasher.putObject((Object)start, (Funnel)this.labelFunnel).putObject((Object)end, (Funnel)this.labelFunnel).putObject((Object)handler, (Funnel)this.labelFunnel).putUnencodedChars((CharSequence)type);
    }
}

