/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.generate;

import com.github.fge.grappa.exceptions.InvalidGrammarException;
import com.github.fge.grappa.misc.AsmUtils;
import com.github.fge.grappa.parsers.BaseParser;
import com.github.fge.grappa.transform.CodeBlock;
import com.github.fge.grappa.transform.base.ParserClassNode;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public final class ConstructorGenerator {
    public void process(ParserClassNode classNode) {
        Objects.requireNonNull(classNode, "classNode");
        List<MethodNode> constructors = classNode.getConstructors();
        if (constructors.isEmpty()) {
            throw new InvalidGrammarException("parser class \"%s\" has no visible constructor for derives classes");
        }
        for (MethodNode constructor : constructors) {
            ConstructorGenerator.createConstuctor(classNode, constructor);
        }
        ConstructorGenerator.createNewInstanceMethod(classNode);
    }

    private static void createConstuctor(ParserClassNode classNode, MethodNode constructor) {
        List exceptions = constructor.exceptions;
        MethodNode newConstructor = new MethodNode(1, constructor.name, constructor.desc, constructor.signature, exceptions.toArray(new String[exceptions.size()]));
        InsnList instructions = newConstructor.instructions;
        CodeBlock block = CodeBlock.newCodeBlock().aload(0).addAll(AsmUtils.createArgumentLoaders(constructor.desc)).invokespecial(classNode.getParentType().getInternalName(), "<init>", constructor.desc).rawReturn();
        instructions.add(block.getInstructionList());
        classNode.methods.add(newConstructor);
    }

    private static void createNewInstanceMethod(ParserClassNode classNode) {
        String desc = "()L" + Type.getType(BaseParser.class).getInternalName() + ';';
        MethodNode method = new MethodNode(1, "newInstance", desc, null, null);
        InsnList instructions = method.instructions;
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, classNode.name));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, classNode.name, "<init>", "()V", false));
        instructions.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(method);
    }
}

