/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform;

import com.github.fge.grappa.misc.AsmUtils;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.generate.ActionClassGenerator;
import com.github.fge.grappa.transform.generate.ClassNodeInitializer;
import com.github.fge.grappa.transform.generate.ConstructorGenerator;
import com.github.fge.grappa.transform.generate.VarInitClassGenerator;
import com.github.fge.grappa.transform.process.BodyWithSuperCallReplacer;
import com.github.fge.grappa.transform.process.CachingGenerator;
import com.github.fge.grappa.transform.process.ImplicitActionsConverter;
import com.github.fge.grappa.transform.process.InstructionGraphCreator;
import com.github.fge.grappa.transform.process.InstructionGroupCreator;
import com.github.fge.grappa.transform.process.InstructionGroupPreparer;
import com.github.fge.grappa.transform.process.LabellingGenerator;
import com.github.fge.grappa.transform.process.ReturnInstructionUnifier;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import com.github.fge.grappa.transform.process.RuleMethodRewriter;
import com.github.fge.grappa.transform.process.SuperCallRewriter;
import com.github.fge.grappa.transform.process.UnusedLabelsRemover;
import com.github.fge.grappa.transform.process.VarFramingGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class ParserTransformer {
    private ParserTransformer() {
    }

    public static synchronized <T> Class<? extends T> transformParser(Class<T> parserClass) throws Exception {
        Objects.requireNonNull(parserClass, "parserClass");
        String name = AsmUtils.getExtendedParserClassName(parserClass.getName());
        Class<?> extendedClass = AsmUtils.findLoadedClass(name, parserClass.getClassLoader());
        Class<?> ret = extendedClass != null ? extendedClass : ParserTransformer.extendParserClass(parserClass).getExtendedClass();
        return ret;
    }

    public static byte[] getByteCode(Class<?> parserClass) throws Exception {
        ParserClassNode node = ParserTransformer.extendParserClass(parserClass);
        return node.getClassCode();
    }

    @VisibleForTesting
    public static ParserClassNode extendParserClass(Class<?> parserClass) throws Exception {
        ParserClassNode classNode = new ParserClassNode(parserClass);
        new ClassNodeInitializer().process(classNode);
        ParserTransformer.runMethodTransformers(classNode);
        new ConstructorGenerator().process(classNode);
        ParserTransformer.defineExtendedParserClass(classNode);
        return classNode;
    }

    private static void runMethodTransformers(ParserClassNode classNode) throws Exception {
        List<RuleMethodProcessor> methodProcessors = ParserTransformer.createRuleMethodProcessors();
        for (RuleMethod ruleMethod : classNode.getRuleMethods().values()) {
            if (ruleMethod.hasDontExtend()) continue;
            for (RuleMethodProcessor methodProcessor : methodProcessors) {
                if (!methodProcessor.appliesTo(classNode, ruleMethod)) continue;
                methodProcessor.process(classNode, ruleMethod);
            }
        }
        for (RuleMethod ruleMethod : classNode.getRuleMethods().values()) {
            if (ruleMethod.isGenerationSkipped()) continue;
            classNode.methods.add(ruleMethod);
        }
    }

    private static List<RuleMethodProcessor> createRuleMethodProcessors() {
        return ImmutableList.of((Object)new UnusedLabelsRemover(), (Object)new ReturnInstructionUnifier(), (Object)new InstructionGraphCreator(), (Object)new ImplicitActionsConverter(), (Object)new InstructionGroupCreator(), (Object)new InstructionGroupPreparer(), (Object)new ActionClassGenerator(false), (Object)new VarInitClassGenerator(false), (Object)new RuleMethodRewriter(), (Object)new SuperCallRewriter(), (Object)new BodyWithSuperCallReplacer(), (Object)new VarFramingGenerator(), (Object[])new RuleMethodProcessor[]{new LabellingGenerator(), new CachingGenerator()});
    }

    private static void defineExtendedParserClass(ParserClassNode node) {
        ClassWriter classWriter = new ClassWriter(2);
        node.accept((ClassVisitor)classWriter);
        node.setClassCode(classWriter.toByteArray());
        Class<?> extendedClass = AsmUtils.loadClass(node.name.replace('/', '.'), node.getClassCode(), node.getParentClass().getClassLoader());
        node.setExtendedClass(extendedClass);
    }
}

