/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;

public final class LoadingOpcode {
    private static final Map<Integer, Integer> LOADING_OPCODES;

    private LoadingOpcode() {
    }

    public static int forType(@Nonnull Type type) {
        Objects.requireNonNull(type);
        return (Integer)Optional.fromNullable((Object)LOADING_OPCODES.get(type.getSort())).get();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)1, (Object)21);
        builder.put((Object)3, (Object)21);
        builder.put((Object)2, (Object)21);
        builder.put((Object)4, (Object)21);
        builder.put((Object)5, (Object)21);
        builder.put((Object)8, (Object)24);
        builder.put((Object)6, (Object)23);
        builder.put((Object)7, (Object)22);
        builder.put((Object)10, (Object)25);
        builder.put((Object)9, (Object)25);
        LOADING_OPCODES = builder.build();
    }
}

