/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.AbstractMatcher;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.support.Chars;

public final class CharMatcher
extends AbstractMatcher {
    private final char character;

    public CharMatcher(char character) {
        super(CharMatcher.getLabel(character));
        this.character = character;
    }

    @Override
    public MatcherType getType() {
        return MatcherType.TERMINAL;
    }

    private static String getLabel(char c) {
        switch (c) {
            case '\uffff': {
                return Chars.escape(c);
            }
        }
        return '\'' + Chars.escape(c) + '\'';
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (context.getCurrentChar() != this.character) {
            return false;
        }
        context.advanceIndex(1);
        return true;
    }
}

