/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.AbstractMatcher;
import com.github.fge.grappa.rules.Action;
import com.github.fge.grappa.rules.SkippableAction;
import com.github.fge.grappa.run.context.ContextAware;
import com.github.fge.grappa.run.context.MatcherContext;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;

public final class ActionMatcher
extends AbstractMatcher {
    private final Action<?> action;
    private final List<ContextAware<?>> contextAwares = Lists.newArrayList();
    private final boolean skipInPredicates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMatcher(Action<?> action) {
        super(Objects.requireNonNull(action).toString());
        this.action = action;
        this.skipInPredicates = action instanceof SkippableAction && ((SkippableAction)action).skipInPredicates();
        Class<?> actionClass = action.getClass();
        if (actionClass.isSynthetic()) {
            return;
        }
        if (action instanceof ContextAware) {
            this.contextAwares.add((ContextAware)((Object)action));
        }
        for (Field field : actionClass.getDeclaredFields()) {
            if (!field.isSynthetic() || !ContextAware.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                ContextAware contextAware = (ContextAware)field.get(action);
                if (contextAware == null) continue;
                this.contextAwares.add(contextAware);
            }
            catch (IllegalAccessException ignored) {
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    @Override
    public MatcherType getType() {
        return MatcherType.ACTION;
    }

    @Override
    public <V> MatcherContext<V> getSubContext(MatcherContext<V> context) {
        MatcherContext<V> subContext = context.getBasicSubContext();
        subContext.setMatcher(this);
        return context.getCurrentIndex() > context.getStartIndex() ? subContext : context.getSubContext(this);
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (this.skipInPredicates && context.inPredicate()) {
            return true;
        }
        MatcherContext<V> parentContext = context.getParent();
        for (ContextAware<?> contextAware : this.contextAwares) {
            contextAware.setContext(parentContext);
        }
        Object valueStackSnapshot = context.getValueStack().takeSnapshot();
        if (!this.action.run(parentContext)) {
            context.getValueStack().restoreSnapshot(valueStackSnapshot);
            return false;
        }
        context.setCurrentIndex(parentContext.getCurrentIndex());
        return true;
    }
}

