/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.spring.jdbc.oracle;

import com.github.ferstl.spring.jdbc.oracle.NamedSqlValue;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Objects;
import javax.sql.DataSource;
import oracle.jdbc.OraclePreparedStatement;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.SqlTypeValue;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.SqlValue;
import org.springframework.lang.Nullable;

public final class OracleNamedParameterJdbcTemplate
extends NamedParameterJdbcTemplate {
    public OracleNamedParameterJdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public OracleNamedParameterJdbcTemplate(JdbcOperations classicJdbcTemplate) {
        super(classicJdbcTemplate);
    }

    public int update(String sql, SqlParameterSource parameterSource, KeyHolder generatedKeyHolder, @Nullable String[] keyColumnNames) {
        boolean returnGeneratedKeys = keyColumnNames != null;
        return this.getJdbcOperations().update((PreparedStatementCreator)new NamedPreparedStatementCreator(sql, parameterSource, returnGeneratedKeys, keyColumnNames), generatedKeyHolder);
    }

    public int[] batchUpdate(final String sql, final SqlParameterSource[] batchArgs) {
        return this.getJdbcOperations().batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                SqlParameterSource parameterSource = batchArgs[i];
                NamedPreparedStatementCreator satementSetter = new NamedPreparedStatementCreator(sql, parameterSource);
                satementSetter.setValues(ps);
            }

            public int getBatchSize() {
                return batchArgs.length;
            }
        });
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource parameterSource) {
        return new NamedPreparedStatementCreator(sql, parameterSource);
    }

    protected ParsedSql getParsedSql(String sql) {
        throw new UnsupportedOperationException("parsing SQL is not supported");
    }

    static final class NamedPreparedStatementCreator
    implements PreparedStatementCreator,
    PreparedStatementSetter,
    SqlProvider,
    ParameterDisposer {
        private final String sql;
        private final SqlParameterSource parameterSource;
        private final boolean returnGeneratedKeys;
        @Nullable
        private final String[] generatedKeysColumnNames;

        NamedPreparedStatementCreator(String sql, SqlParameterSource parameterSource) {
            Objects.requireNonNull(sql);
            Objects.requireNonNull(parameterSource);
            this.sql = sql;
            this.parameterSource = parameterSource;
            this.returnGeneratedKeys = false;
            this.generatedKeysColumnNames = null;
        }

        NamedPreparedStatementCreator(String sql, SqlParameterSource parameterSource, boolean returnGeneratedKeys, String[] generatedKeysColumnNames) {
            Objects.requireNonNull(sql);
            Objects.requireNonNull(parameterSource);
            this.sql = sql;
            this.parameterSource = parameterSource;
            this.returnGeneratedKeys = false;
            this.generatedKeysColumnNames = null;
        }

        public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            PreparedStatement statement = this.generatedKeysColumnNames != null ? connection.prepareStatement(this.sql, this.generatedKeysColumnNames) : (this.returnGeneratedKeys ? connection.prepareStatement(this.sql, 1) : connection.prepareStatement(this.sql));
            this.setValues(statement);
            return statement;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            OraclePreparedStatement statement = ps.unwrap(OraclePreparedStatement.class);
            for (String parameterName : this.parameterSource.getParameterNames()) {
                int sqlType = this.parameterSource.getSqlType(parameterName);
                Object value = this.parameterSource.getValue(parameterName);
                NamedPreparedStatementCreator.validateValue(value);
                if (value != null) {
                    NamedPreparedStatementCreator.setValue(statement, parameterName, value, sqlType);
                    continue;
                }
                String typeName = this.parameterSource.getTypeName(parameterName);
                NamedPreparedStatementCreator.setNull(statement, parameterName, sqlType, typeName);
            }
        }

        private static void validateValue(Object value) {
            if (value instanceof SqlValue && !(value instanceof NamedSqlValue)) {
                throw new IllegalArgumentException("SqlValue not supported, use NamedSqlValue");
            }
            if (value instanceof SqlTypeValue) {
                throw new IllegalArgumentException("SqlTypeValue not supported, use NamedSqlValue");
            }
            if (value instanceof Collection) {
                throw new IllegalArgumentException("Collection not supported");
            }
        }

        private static void setValue(OraclePreparedStatement oracleStatement, String parameterName, Object value, int sqlType) throws SQLException {
            if (value instanceof NamedSqlValue) {
                NamedSqlValue sqlValue = (NamedSqlValue)value;
                sqlValue.setValue((PreparedStatement)oracleStatement, parameterName);
            } else {
                Object bindParameter = NamedPreparedStatementCreator.convertToBindable(value);
                if (sqlType != Integer.MIN_VALUE) {
                    oracleStatement.setObjectAtName(parameterName, bindParameter, sqlType);
                } else {
                    oracleStatement.setObjectAtName(parameterName, bindParameter);
                }
            }
        }

        private static Object convertToBindable(Object object) {
            if (object instanceof java.util.Date) {
                return NamedPreparedStatementCreator.convertToSqlTemporal((java.util.Date)object);
            }
            return object;
        }

        private static Object convertToSqlTemporal(java.util.Date date) {
            if (date instanceof Date) {
                return date;
            }
            if (date instanceof Timestamp) {
                return date;
            }
            if (date instanceof Time) {
                return date;
            }
            return NamedPreparedStatementCreator.copyDate(date);
        }

        private static Object copyDate(java.util.Date date) {
            return new Timestamp(date.getTime());
        }

        private static void setNull(OraclePreparedStatement oracleStatement, String parameterName, int sqlType, String typeName) throws SQLException {
            if (sqlType != Integer.MIN_VALUE) {
                if (typeName != null) {
                    oracleStatement.setNullAtName(parameterName, sqlType, typeName);
                } else {
                    oracleStatement.setNullAtName(parameterName, sqlType);
                }
            } else {
                oracleStatement.setNullAtName(parameterName, 0);
            }
        }

        public String getSql() {
            return this.sql;
        }

        public void cleanupParameters() {
            for (String parameterName : this.parameterSource.getParameterNames()) {
                Object value = this.parameterSource.getValue(parameterName);
                if (!(value instanceof SqlValue)) continue;
                ((SqlValue)value).cleanup();
            }
        }
    }
}

