/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.GraphFormat;
import com.github.ferstl.depgraph.dependency.DependencyGraphException;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.dependency.GraphStyleConfigurer;
import com.github.ferstl.depgraph.dependency.dot.DotGraphStyleConfigurer;
import com.github.ferstl.depgraph.dependency.dot.style.StyleConfiguration;
import com.github.ferstl.depgraph.dependency.dot.style.resource.BuiltInStyleResource;
import com.github.ferstl.depgraph.dependency.dot.style.resource.ClasspathStyleResource;
import com.github.ferstl.depgraph.dependency.dot.style.resource.FileSystemStyleResource;
import com.github.ferstl.depgraph.dependency.dot.style.resource.StyleResource;
import com.github.ferstl.depgraph.dependency.gml.GmlGraphStyleConfigurer;
import com.github.ferstl.depgraph.dependency.json.JsonGraphStyleConfigurer;
import com.github.ferstl.depgraph.dependency.puml.PumlGraphStyleConfigurer;
import com.github.ferstl.depgraph.dependency.text.TextGraphStyleConfigurer;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

abstract class AbstractGraphMojo
extends AbstractMojo {
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\r?\n");
    private static final String OUTPUT_FILE_NAME = "dependency-graph";
    @Parameter(property="scope")
    private String scope;
    @Parameter(property="includes")
    private List<String> includes;
    @Parameter(property="excludes")
    private List<String> excludes;
    @Parameter(property="transitiveIncludes")
    private List<String> transitiveIncludes;
    @Parameter(property="transitiveExcludes")
    private List<String> transitiveExcludes;
    @Parameter(property="targetIncludes")
    private List<String> targetIncludes;
    @Parameter(property="excludeOptionalDependencies", defaultValue="false")
    private boolean excludeOptionalDependencies;
    @Parameter(property="graphFormat", defaultValue="dot")
    private String graphFormat;
    @Parameter(property="showAllAttributesForJson", defaultValue="true")
    private boolean showAllAttributesForJson;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(property="outputFileName", defaultValue="dependency-graph")
    private String outputFileName;
    @Parameter(property="useArtifactIdInFileName", defaultValue="false")
    private boolean useArtifactIdInFileName;
    @Parameter(property="createImage", defaultValue="false")
    private boolean createImage;
    @Parameter(property="imageFormat", defaultValue="png")
    private String imageFormat;
    @Parameter(property="dotExecutable")
    private File dotExecutable;
    @Parameter(property="customStyleConfiguration")
    private String customStyleConfiguration;
    @Parameter(property="printStyleConfiguration", defaultValue="false")
    private boolean printStyleConfiguration;
    @Parameter(property="depgraph.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    private String artifactId;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    ProjectDependenciesResolver dependenciesResolver;

    AbstractGraphMojo() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        GraphFormat graphFormat = GraphFormat.forName(this.graphFormat);
        ArtifactFilter globalFilter = this.createGlobalArtifactFilter();
        ArtifactFilter transitiveIncludeExcludeFilter = this.createTransitiveIncludeExcludeFilter();
        ArtifactFilter targetFilter = this.createTargetArtifactFilter();
        GraphStyleConfigurer graphStyleConfigurer = this.createGraphStyleConfigurer(graphFormat);
        Path graphFilePath = this.createGraphFilePath(graphFormat);
        try {
            GraphFactory graphFactory = this.createGraphFactory(globalFilter, transitiveIncludeExcludeFilter, targetFilter, graphStyleConfigurer);
            String dependencyGraph = graphFactory.createGraph(this.getProject());
            this.writeGraphFile(dependencyGraph, graphFilePath);
            if (graphFormat == GraphFormat.DOT && this.createImage) {
                this.createDotGraphImage(graphFilePath);
            } else if (graphFormat == GraphFormat.TEXT) {
                this.getLog().info((CharSequence)("Dependency graph:\n" + dependencyGraph));
            }
        }
        catch (DependencyGraphException e) {
            throw new MojoExecutionException("Unable to create dependency graph.", e.getCause());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write graph file.", (Exception)e);
        }
    }

    protected abstract GraphFactory createGraphFactory(ArtifactFilter var1, ArtifactFilter var2, ArtifactFilter var3, GraphStyleConfigurer var4);

    protected Set<BuiltInStyleResource> getAdditionalStyleResources() {
        return new LinkedHashSet<BuiltInStyleResource>();
    }

    protected boolean showFullGraph() {
        return GraphFormat.forName(this.graphFormat) == GraphFormat.JSON && this.showAllAttributesForJson;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    private ArtifactFilter createGlobalArtifactFilter() {
        AndArtifactFilter filter = new AndArtifactFilter();
        if (this.scope != null) {
            filter.add((ArtifactFilter)new ScopeArtifactFilter(this.scope));
        }
        if (!this.includes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(this.includes));
        }
        if (!this.excludes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternExcludesArtifactFilter(this.excludes));
        }
        if (this.excludeOptionalDependencies) {
            filter.add((ArtifactFilter)new OptionalArtifactFilter());
        }
        return filter;
    }

    private ArtifactFilter createTransitiveIncludeExcludeFilter() {
        AndArtifactFilter filter = new AndArtifactFilter();
        if (!this.transitiveIncludes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(this.transitiveIncludes));
        }
        if (!this.transitiveExcludes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternExcludesArtifactFilter(this.transitiveExcludes));
        }
        return filter;
    }

    private ArtifactFilter createTargetArtifactFilter() {
        AndArtifactFilter filter = new AndArtifactFilter();
        if (!this.targetIncludes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(this.targetIncludes));
        }
        return filter;
    }

    private GraphStyleConfigurer createGraphStyleConfigurer(GraphFormat graphFormat) throws MojoFailureException {
        switch (graphFormat) {
            case DOT: {
                StyleConfiguration styleConfiguration = this.loadStyleConfiguration();
                return new DotGraphStyleConfigurer(styleConfiguration);
            }
            case GML: {
                return new GmlGraphStyleConfigurer();
            }
            case PUML: {
                return new PumlGraphStyleConfigurer();
            }
            case JSON: {
                return new JsonGraphStyleConfigurer();
            }
            case TEXT: {
                return new TextGraphStyleConfigurer();
            }
        }
        throw new IllegalArgumentException("Unsupported output format: " + (Object)((Object)graphFormat));
    }

    private StyleConfiguration loadStyleConfiguration() throws MojoFailureException {
        ClasspathStyleResource defaultStyleResource = BuiltInStyleResource.DEFAULT_STYLE.createStyleResource(((Object)((Object)this)).getClass().getClassLoader());
        LinkedHashSet<StyleResource> styleResources = new LinkedHashSet<StyleResource>();
        for (BuiltInStyleResource additionalResource : this.getAdditionalStyleResources()) {
            styleResources.add(additionalResource.createStyleResource(((Object)((Object)this)).getClass().getClassLoader()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.customStyleConfiguration)) {
            StyleResource customStyleResource = this.getCustomStyleResource();
            this.getLog().info((CharSequence)("Using custom style configuration " + customStyleResource));
            styleResources.add(customStyleResource);
        }
        StyleConfiguration styleConfiguration = StyleConfiguration.load(defaultStyleResource, styleResources.toArray(new StyleResource[0]));
        if (this.printStyleConfiguration) {
            this.getLog().info((CharSequence)("Using effective style configuration:\n" + styleConfiguration.toJson()));
        }
        return styleConfiguration;
    }

    private StyleResource getCustomStyleResource() throws MojoFailureException {
        StyleResource customStyleResource;
        if (StringUtils.startsWith((CharSequence)this.customStyleConfiguration, (CharSequence)"classpath:")) {
            String resourceName = StringUtils.substring((String)this.customStyleConfiguration, (int)10, (int)this.customStyleConfiguration.length());
            customStyleResource = new ClasspathStyleResource(resourceName, ((Object)((Object)this)).getClass().getClassLoader());
        } else {
            customStyleResource = new FileSystemStyleResource(Paths.get(this.customStyleConfiguration, new String[0]));
        }
        if (!customStyleResource.exists()) {
            throw new MojoFailureException("Custom configuration '" + this.customStyleConfiguration + "' does not exist.");
        }
        return customStyleResource;
    }

    private Path createGraphFilePath(GraphFormat graphFormat) {
        String fileName = this.useArtifactIdInFileName ? this.artifactId : this.outputFileName;
        fileName = this.addFileExtensionIfNeeded(graphFormat, fileName);
        if (this.isOutputDirectoryResolved()) {
            return this.outputDirectory.toPath().resolve(fileName);
        }
        return Paths.get(System.getProperty("user.dir"), fileName);
    }

    private String addFileExtensionIfNeeded(GraphFormat graphFormat, String fileName) {
        String fileExtension = graphFormat.getFileExtension();
        if (!fileName.endsWith(fileExtension)) {
            fileName = fileName + fileExtension;
        }
        return fileName;
    }

    private boolean isOutputDirectoryResolved() {
        return !this.outputDirectory.toString().contains("${project.basedir}");
    }

    private void writeGraphFile(String graph, Path graphFilePath) throws IOException {
        Path parent = graphFilePath.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(graphFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(graph);
        }
    }

    private void createDotGraphImage(Path graphFilePath) throws IOException {
        int exitCode;
        String graphFileName = this.createDotImageFileName(graphFilePath);
        Path graphFile = graphFilePath.resolveSibling(graphFileName);
        String dotExecutable = this.determineDotExecutable();
        Object[] arguments = new String[]{"-T", this.imageFormat, "-o", graphFile.toAbsolutePath().toString(), graphFilePath.toAbsolutePath().toString()};
        Commandline cmd = new Commandline();
        cmd.setExecutable(dotExecutable);
        cmd.addArguments((String[])arguments);
        this.getLog().info((CharSequence)("Running Graphviz: " + dotExecutable + " " + Joiner.on((String)" ").join(arguments)));
        CommandLineUtils.StringStreamConsumer systemOut = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer systemErr = new CommandLineUtils.StringStreamConsumer();
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)systemOut, (StreamConsumer)systemErr);
        }
        catch (CommandLineException e) {
            throw new IOException("Unable to execute Graphviz", e);
        }
        Splitter lineSplitter = Splitter.on((Pattern)LINE_SEPARATOR_PATTERN).omitEmptyStrings().trimResults();
        Iterable output = Iterables.concat((Iterable)lineSplitter.split((CharSequence)systemOut.getOutput()), (Iterable)lineSplitter.split((CharSequence)systemErr.getOutput()));
        for (String line : output) {
            this.getLog().info((CharSequence)("  dot> " + line));
        }
        if (exitCode != 0) {
            throw new IOException("Graphviz terminated abnormally. Exit code: " + exitCode);
        }
        this.getLog().info((CharSequence)("Graph image created on " + graphFile.toAbsolutePath()));
    }

    private String createDotImageFileName(Path graphFilePath) {
        String graphFileName = graphFilePath.getFileName().toString();
        graphFileName = graphFileName.endsWith(GraphFormat.DOT.getFileExtension()) ? graphFileName.substring(0, graphFileName.lastIndexOf(".")) + "." + this.imageFormat : graphFileName + this.imageFormat;
        return graphFileName;
    }

    private String determineDotExecutable() throws IOException {
        if (this.dotExecutable == null) {
            return "dot";
        }
        Path dotExecutablePath = this.dotExecutable.toPath();
        if (!Files.exists(dotExecutablePath, new LinkOption[0])) {
            throw new NoSuchFileException("The dot executable '" + this.dotExecutable + "' does not exist.");
        }
        if (Files.isDirectory(dotExecutablePath, new LinkOption[0]) || !Files.isExecutable(dotExecutablePath)) {
            throw new IOException("The dot executable '" + this.dotExecutable + "' is not a file or cannot be executed.");
        }
        return dotExecutablePath.toAbsolutePath().toString();
    }

    private static class OptionalArtifactFilter
    implements ArtifactFilter {
        private OptionalArtifactFilter() {
        }

        public boolean include(Artifact artifact) {
            return !artifact.isOptional();
        }
    }
}

