/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import com.felhr.usbserial.UsbSerialInterface;
import java.io.OutputStream;

public class SerialOutputStream
extends OutputStream {
    private int timeout = 0;
    protected final UsbSerialInterface device;

    public SerialOutputStream(UsbSerialInterface device) {
        this.device = device;
    }

    @Override
    public void write(int b) {
        this.device.syncWrite(new byte[]{(byte)b}, this.timeout);
    }

    @Override
    public void write(byte[] b) {
        this.device.syncWrite(b, this.timeout);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0) {
            throw new IndexOutOfBoundsException("Offset must be >= 0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Length must positive");
        }
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException("off + length greater than buffer length");
        }
        if (off == 0 && len == b.length) {
            this.write(b);
            return;
        }
        this.device.syncWrite(b, off, len, this.timeout);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

