/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.felhr.usbserial.AbstractWorkerThread;
import com.felhr.usbserial.SerialInputStream;
import com.felhr.usbserial.SerialOutputStream;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;
import com.felhr.utils.SafeUsbRequest;

public class CP2102SerialDevice
extends UsbSerialDevice {
    private static final String CLASS_ID = CP2102SerialDevice.class.getSimpleName();
    private static final int CP210x_PURGE = 18;
    private static final int CP210x_IFC_ENABLE = 0;
    private static final int CP210x_SET_BAUDDIV = 1;
    private static final int CP210x_SET_LINE_CTL = 3;
    private static final int CP210x_GET_LINE_CTL = 4;
    private static final int CP210X_SET_BREAK = 5;
    private static final int CP210x_SET_MHS = 7;
    private static final int CP210x_SET_BAUDRATE = 30;
    private static final int CP210x_SET_FLOW = 19;
    private static final int CP210x_SET_XON = 9;
    private static final int CP210x_SET_XOFF = 10;
    private static final int CP210x_SET_CHARS = 25;
    private static final int CP210x_GET_MDMSTS = 8;
    private static final int CP210x_GET_COMM_STATUS = 16;
    private static final int CP210x_REQTYPE_HOST2DEVICE = 65;
    private static final int CP210x_REQTYPE_DEVICE2HOST = 193;
    private static final int CP210x_BREAK_ON = 1;
    private static final int CP210x_BREAK_OFF = 0;
    private static final int CP210x_MHS_RTS_ON = 514;
    private static final int CP210x_MHS_RTS_OFF = 512;
    private static final int CP210x_MHS_DTR_ON = 257;
    private static final int CP210x_MHS_DTR_OFF = 256;
    private static final int CP210x_PURGE_ALL = 15;
    private static final int CP210x_UART_ENABLE = 1;
    private static final int CP210x_UART_DISABLE = 0;
    private static final int CP210x_LINE_CTL_DEFAULT = 2048;
    private static final int CP210x_MHS_DEFAULT = 0;
    private static final int CP210x_MHS_DTR = 1;
    private static final int CP210x_MHS_RTS = 16;
    private static final int CP210x_MHS_ALL = 17;
    private static final int CP210x_XON = 0;
    private static final int CP210x_XOFF = 0;
    private static final int DEFAULT_BAUDRATE = 9600;
    private boolean rtsCtsEnabled = false;
    private boolean dtrDsrEnabled = false;
    private boolean ctsState = true;
    private boolean dsrState = true;
    private UsbSerialInterface.UsbCTSCallback ctsCallback;
    private UsbSerialInterface.UsbDSRCallback dsrCallback;
    private final UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private FlowControlThread flowControlThread;
    private UsbSerialInterface.UsbParityCallback parityCallback;
    private UsbSerialInterface.UsbBreakCallback breakCallback;
    private UsbSerialInterface.UsbFrameCallback frameCallback;
    private UsbSerialInterface.UsbOverrunCallback overrunCallback;

    public CP2102SerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        this(device, connection, -1);
    }

    public CP2102SerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        super(device, connection);
        this.mInterface = device.getInterface(iface >= 0 ? iface : 0);
    }

    @Override
    public boolean open() {
        boolean ret = this.openCP2102();
        if (ret) {
            SafeUsbRequest requestIN = new SafeUsbRequest();
            requestIN.initialize(this.connection, this.inEndpoint);
            this.restartWorkingThread();
            this.restartWriteThread();
            this.createFlowControlThread();
            this.setThreadsParams(requestIN, this.outEndpoint);
            this.asyncMode = true;
            this.isOpen = true;
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void close() {
        this.setControlCommand(18, 15, null);
        this.setControlCommand(0, 0, null);
        this.killWorkingThread();
        this.killWriteThread();
        this.stopFlowControlThread();
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public boolean syncOpen() {
        boolean ret = this.openCP2102();
        if (ret) {
            this.createFlowControlThread();
            this.setSyncParams(this.inEndpoint, this.outEndpoint);
            this.asyncMode = false;
            this.isOpen = true;
            this.inputStream = new SerialInputStream(this);
            this.outputStream = new SerialOutputStream(this);
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void syncClose() {
        this.setControlCommand(18, 15, null);
        this.setControlCommand(0, 0, null);
        this.stopFlowControlThread();
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public void setBaudRate(int baudRate) {
        byte[] data = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF)};
        this.setControlCommand(30, 0, data);
    }

    @Override
    public void setDataBits(int dataBits) {
        short wValue = this.getCTL();
        wValue = (short)(wValue & 0xFFFFF0FF);
        switch (dataBits) {
            case 5: {
                wValue = (short)(wValue | 0x500);
                break;
            }
            case 6: {
                wValue = (short)(wValue | 0x600);
                break;
            }
            case 7: {
                wValue = (short)(wValue | 0x700);
                break;
            }
            case 8: {
                wValue = (short)(wValue | 0x800);
                break;
            }
            default: {
                return;
            }
        }
        this.setControlCommand(3, wValue, null);
    }

    @Override
    public void setStopBits(int stopBits) {
        short wValue = this.getCTL();
        wValue = (short)(wValue & 0xFFFFFFFC);
        switch (stopBits) {
            case 1: {
                wValue = (short)(wValue | 0);
                break;
            }
            case 3: {
                wValue = (short)(wValue | 1);
                break;
            }
            case 2: {
                wValue = (short)(wValue | 2);
                break;
            }
            default: {
                return;
            }
        }
        this.setControlCommand(3, wValue, null);
    }

    @Override
    public void setParity(int parity) {
        short wValue = this.getCTL();
        wValue = (short)(wValue & 0xFFFFFF0F);
        switch (parity) {
            case 0: {
                wValue = (short)(wValue | 0);
                break;
            }
            case 1: {
                wValue = (short)(wValue | 0x10);
                break;
            }
            case 2: {
                wValue = (short)(wValue | 0x20);
                break;
            }
            case 3: {
                wValue = (short)(wValue | 0x30);
                break;
            }
            case 4: {
                wValue = (short)(wValue | 0x40);
                break;
            }
            default: {
                return;
            }
        }
        this.setControlCommand(3, wValue, null);
    }

    @Override
    public void setFlowControl(int flowControl) {
        switch (flowControl) {
            case 0: {
                byte[] dataOff = new byte[]{1, 0, 0, 0, 64, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                this.rtsCtsEnabled = false;
                this.dtrDsrEnabled = false;
                this.setControlCommand(19, 0, dataOff);
                break;
            }
            case 1: {
                byte[] dataRTSCTS = new byte[]{9, 0, 0, 0, 64, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                this.rtsCtsEnabled = true;
                this.dtrDsrEnabled = false;
                this.setControlCommand(19, 0, dataRTSCTS);
                this.setControlCommand(7, 514, null);
                byte[] commStatusCTS = this.getCommStatus();
                this.ctsState = (commStatusCTS[4] & 1) == 0;
                this.startFlowControlThread();
                break;
            }
            case 2: {
                byte[] dataDSRDTR = new byte[]{17, 0, 0, 0, 64, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                this.dtrDsrEnabled = true;
                this.rtsCtsEnabled = false;
                this.setControlCommand(19, 0, dataDSRDTR);
                this.setControlCommand(7, 257, null);
                byte[] commStatusDSR = this.getCommStatus();
                this.dsrState = (commStatusDSR[4] & 2) == 0;
                this.startFlowControlThread();
                break;
            }
            case 3: {
                byte[] dataXONXOFF = new byte[]{1, 0, 0, 0, 67, 0, 0, 0, 0, -128, 0, 0, 0, 32, 0, 0};
                byte[] dataChars = new byte[]{0, 0, 0, 0, 17, 19};
                this.setControlCommand(25, 0, dataChars);
                this.setControlCommand(19, 0, dataXONXOFF);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void setBreak(boolean state) {
        if (state) {
            this.setControlCommand(5, 1, null);
        } else {
            this.setControlCommand(5, 0, null);
        }
    }

    @Override
    public void setRTS(boolean state) {
        if (state) {
            this.setControlCommand(7, 514, null);
        } else {
            this.setControlCommand(7, 512, null);
        }
    }

    @Override
    public void setDTR(boolean state) {
        if (state) {
            this.setControlCommand(7, 257, null);
        } else {
            this.setControlCommand(7, 256, null);
        }
    }

    @Override
    public void getCTS(UsbSerialInterface.UsbCTSCallback ctsCallback) {
        this.ctsCallback = ctsCallback;
    }

    @Override
    public void getDSR(UsbSerialInterface.UsbDSRCallback dsrCallback) {
        this.dsrCallback = dsrCallback;
    }

    @Override
    public void getBreak(UsbSerialInterface.UsbBreakCallback breakCallback) {
        this.breakCallback = breakCallback;
    }

    @Override
    public void getFrame(UsbSerialInterface.UsbFrameCallback frameCallback) {
        this.frameCallback = frameCallback;
    }

    @Override
    public void getOverrun(UsbSerialInterface.UsbOverrunCallback overrunCallback) {
        this.overrunCallback = overrunCallback;
    }

    @Override
    public void getParity(UsbSerialInterface.UsbParityCallback parityCallback) {
        this.parityCallback = parityCallback;
        this.startFlowControlThread();
    }

    private boolean openCP2102() {
        if (!this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
            return false;
        }
        Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            this.outEndpoint = endpoint;
        }
        if (this.setControlCommand(0, 1, null) < 0) {
            return false;
        }
        this.setBaudRate(9600);
        if (this.setControlCommand(3, 2048, null) < 0) {
            return false;
        }
        this.setFlowControl(0);
        return this.setControlCommand(7, 0, null) >= 0;
    }

    private void createFlowControlThread() {
        this.flowControlThread = new FlowControlThread();
    }

    private void startFlowControlThread() {
        if (!this.flowControlThread.isAlive()) {
            this.flowControlThread.start();
        }
    }

    private void stopFlowControlThread() {
        if (this.flowControlThread != null) {
            this.flowControlThread.stopThread();
            this.flowControlThread = null;
        }
    }

    private int setControlCommand(int request, int value, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(65, request, value, this.mInterface.getId(), data, dataLength, 0);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    private byte[] getModemState() {
        byte[] data = new byte[1];
        this.connection.controlTransfer(193, 8, 0, this.mInterface.getId(), data, 1, 0);
        return data;
    }

    private byte[] getCommStatus() {
        byte[] data = new byte[19];
        int response = this.connection.controlTransfer(193, 16, 0, this.mInterface.getId(), data, 19, 0);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response (Comm status): " + String.valueOf(response)));
        return data;
    }

    private short getCTL() {
        byte[] data = new byte[2];
        int response = this.connection.controlTransfer(193, 4, 0, this.mInterface.getId(), data, data.length, 0);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return (short)(data[1] << 8 | data[0] & 0xFF);
    }

    private class FlowControlThread
    extends AbstractWorkerThread {
        private final long time = 40L;

        private FlowControlThread() {
        }

        @Override
        public void doRun() {
            if (!this.firstTime) {
                byte[] modemState = this.pollLines();
                byte[] commStatus = CP2102SerialDevice.this.getCommStatus();
                if (CP2102SerialDevice.this.rtsCtsEnabled && CP2102SerialDevice.this.ctsState != ((modemState[0] & 0x10) == 16)) {
                    CP2102SerialDevice.this.ctsState = !CP2102SerialDevice.this.ctsState;
                    if (CP2102SerialDevice.this.ctsCallback != null) {
                        CP2102SerialDevice.this.ctsCallback.onCTSChanged(CP2102SerialDevice.this.ctsState);
                    }
                }
                if (CP2102SerialDevice.this.dtrDsrEnabled && CP2102SerialDevice.this.dsrState != ((modemState[0] & 0x20) == 32)) {
                    CP2102SerialDevice.this.dsrState = !CP2102SerialDevice.this.dsrState;
                    if (CP2102SerialDevice.this.dsrCallback != null) {
                        CP2102SerialDevice.this.dsrCallback.onDSRChanged(CP2102SerialDevice.this.dsrState);
                    }
                }
                if (CP2102SerialDevice.this.parityCallback != null && (commStatus[0] & 0x10) == 16) {
                    CP2102SerialDevice.this.parityCallback.onParityError();
                }
                if (CP2102SerialDevice.this.frameCallback != null && (commStatus[0] & 2) == 2) {
                    CP2102SerialDevice.this.frameCallback.onFramingError();
                }
                if (CP2102SerialDevice.this.breakCallback != null && (commStatus[0] & 1) == 1) {
                    CP2102SerialDevice.this.breakCallback.onBreakInterrupt();
                }
                if (CP2102SerialDevice.this.overrunCallback != null && ((commStatus[0] & 4) == 4 || (commStatus[0] & 8) == 8)) {
                    CP2102SerialDevice.this.overrunCallback.onOverrunError();
                }
            } else {
                if (CP2102SerialDevice.this.rtsCtsEnabled && CP2102SerialDevice.this.ctsCallback != null) {
                    CP2102SerialDevice.this.ctsCallback.onCTSChanged(CP2102SerialDevice.this.ctsState);
                }
                if (CP2102SerialDevice.this.dtrDsrEnabled && CP2102SerialDevice.this.dsrCallback != null) {
                    CP2102SerialDevice.this.dsrCallback.onDSRChanged(CP2102SerialDevice.this.dsrState);
                }
                this.firstTime = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] pollLines() {
            FlowControlThread flowControlThread = this;
            synchronized (flowControlThread) {
                try {
                    this.wait(40L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return CP2102SerialDevice.this.getModemState();
        }
    }
}

