/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import com.felhr.deviceids.CP2130Ids;
import com.felhr.usbserial.CP2130SpiDevice;
import com.felhr.usbserial.SerialBuffer;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSpiInterface;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class UsbSpiDevice
implements UsbSpiInterface {
    private static final String CLASS_ID = UsbSerialDevice.class.getSimpleName();
    protected static final int USB_TIMEOUT = 5000;
    protected final UsbDevice device;
    protected final UsbDeviceConnection connection;
    protected SerialBuffer serialBuffer;
    protected WriteThread writeThread;
    protected ReadThread readThread;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;

    public UsbSpiDevice(UsbDevice device, UsbDeviceConnection connection) {
        this.device = device;
        this.connection = connection;
        this.serialBuffer = new SerialBuffer(false);
    }

    public static UsbSpiDevice createUsbSerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        return UsbSpiDevice.createUsbSerialDevice(device, connection, -1);
    }

    public static UsbSpiDevice createUsbSerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        int pid;
        int vid = device.getVendorId();
        if (CP2130Ids.isDeviceSupported(vid, pid = device.getProductId())) {
            return new CP2130SpiDevice(device, connection, iface);
        }
        return null;
    }

    @Override
    public abstract boolean connectSPI();

    @Override
    public abstract void writeMOSI(byte[] var1);

    @Override
    public abstract void readMISO(int var1);

    @Override
    public abstract void writeRead(byte[] var1, int var2);

    @Override
    public abstract void setClock(int var1);

    @Override
    public abstract void selectSlave(int var1);

    @Override
    public void setMISOCallback(UsbSpiInterface.UsbMISOCallback misoCallback) {
        this.readThread.setCallback(misoCallback);
    }

    @Override
    public abstract int getClockDivider();

    @Override
    public abstract int getSelectedSlave();

    @Override
    public abstract void closeSPI();

    protected void setThreadsParams(UsbEndpoint inEndpoint, UsbEndpoint outEndpoint) {
        if (this.writeThread != null) {
            this.writeThread.setUsbEndpoint(outEndpoint);
        }
        if (this.readThread != null) {
            this.readThread.setUsbEndpoint(inEndpoint);
        }
    }

    protected void killWorkingThread() {
        if (this.readThread != null) {
            this.readThread.stopReadThread();
            this.readThread = null;
        }
    }

    protected void restartWorkingThread() {
        this.readThread = new ReadThread();
        this.readThread.start();
        while (!this.readThread.isAlive()) {
        }
    }

    protected void killWriteThread() {
        if (this.writeThread != null) {
            this.writeThread.stopWriteThread();
            this.writeThread = null;
            this.serialBuffer.resetWriteBuffer();
        }
    }

    protected void restartWriteThread() {
        if (this.writeThread == null) {
            this.writeThread = new WriteThread();
            this.writeThread.start();
            while (!this.writeThread.isAlive()) {
            }
        }
    }

    protected class ReadThread
    extends Thread {
        private UsbSpiInterface.UsbMISOCallback misoCallback;
        private UsbEndpoint inEndpoint;
        private AtomicBoolean working = new AtomicBoolean(true);

        public void setCallback(UsbSpiInterface.UsbMISOCallback misoCallback) {
            this.misoCallback = misoCallback;
        }

        @Override
        public void run() {
            byte[] dataReceived = null;
            while (this.working.get()) {
                int numberBytes = this.inEndpoint != null ? UsbSpiDevice.this.connection.bulkTransfer(this.inEndpoint, UsbSpiDevice.this.serialBuffer.getBufferCompatible(), 16384, 0) : 0;
                if (numberBytes <= 0) continue;
                dataReceived = UsbSpiDevice.this.serialBuffer.getDataReceivedCompatible(numberBytes);
                this.onReceivedData(dataReceived);
            }
        }

        public void setUsbEndpoint(UsbEndpoint inEndpoint) {
            this.inEndpoint = inEndpoint;
        }

        public void stopReadThread() {
            this.working.set(false);
        }

        private void onReceivedData(byte[] data) {
            if (this.misoCallback != null) {
                this.misoCallback.onReceivedData(data);
            }
        }
    }

    protected class WriteThread
    extends Thread {
        private UsbEndpoint outEndpoint;
        private AtomicBoolean working = new AtomicBoolean(true);

        @Override
        public void run() {
            while (this.working.get()) {
                byte[] data = UsbSpiDevice.this.serialBuffer.getWriteBuffer();
                if (data.length <= 0) continue;
                UsbSpiDevice.this.connection.bulkTransfer(this.outEndpoint, data, data.length, 5000);
            }
        }

        public void setUsbEndpoint(UsbEndpoint outEndpoint) {
            this.outEndpoint = outEndpoint;
        }

        public void stopWriteThread() {
            this.working.set(false);
        }
    }
}

