/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import com.felhr.usbserial.UsbSerialInterface;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;

public class SerialInputStream
extends InputStream
implements UsbSerialInterface.UsbReadCallback {
    protected final UsbSerialInterface device;
    protected ArrayBlockingQueue data = new ArrayBlockingQueue(256);
    protected volatile boolean is_open;

    public SerialInputStream(UsbSerialInterface device) {
        this.device = device;
        this.is_open = true;
        device.read(this);
    }

    @Override
    public int read() {
        while (this.is_open) {
            try {
                return (Integer)this.data.take();
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return -1;
    }

    @Override
    public void close() {
        this.is_open = false;
        try {
            this.data.put(-1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onReceivedData(byte[] new_data) {
        for (byte b : new_data) {
            try {
                this.data.put(b & 0xFF);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

