/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import com.felhr.usbserial.UsbSerialDebugger;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SerialBuffer {
    public static final int DEFAULT_READ_BUFFER_SIZE = 16384;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 16384;
    private ByteBuffer readBuffer;
    private SynchronizedBuffer writeBuffer = new SynchronizedBuffer();
    private byte[] readBuffer_compatible;
    private boolean debugging = false;

    public SerialBuffer(boolean version) {
        if (version) {
            this.readBuffer = ByteBuffer.allocate(16384);
        } else {
            this.readBuffer_compatible = new byte[16384];
        }
    }

    public void debug(boolean value) {
        this.debugging = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putReadBuffer(ByteBuffer data) {
        SerialBuffer serialBuffer = this;
        synchronized (serialBuffer) {
            try {
                this.readBuffer.put(data);
            }
            catch (BufferOverflowException bufferOverflowException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getReadBuffer() {
        SerialBuffer serialBuffer = this;
        synchronized (serialBuffer) {
            return this.readBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDataReceived() {
        SerialBuffer serialBuffer = this;
        synchronized (serialBuffer) {
            byte[] dst = new byte[this.readBuffer.position()];
            this.readBuffer.position(0);
            this.readBuffer.get(dst, 0, dst.length);
            if (this.debugging) {
                UsbSerialDebugger.printReadLogGet(dst, true);
            }
            return dst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReadBuffer() {
        SerialBuffer serialBuffer = this;
        synchronized (serialBuffer) {
            this.readBuffer.clear();
        }
    }

    public byte[] getWriteBuffer() {
        return this.writeBuffer.get();
    }

    public void putWriteBuffer(byte[] data) {
        this.writeBuffer.put(data);
    }

    public void resetWriteBuffer() {
        this.writeBuffer.reset();
    }

    public byte[] getBufferCompatible() {
        return this.readBuffer_compatible;
    }

    public byte[] getDataReceivedCompatible(int numberBytes) {
        byte[] tempBuff = Arrays.copyOfRange(this.readBuffer_compatible, 0, numberBytes);
        return tempBuff;
    }

    private class SynchronizedBuffer {
        private byte[] buffer = new byte[16384];
        private int position = -1;

        public synchronized void put(byte[] src) {
            if (src == null || src.length == 0) {
                return;
            }
            if (this.position == -1) {
                this.position = 0;
            }
            if (SerialBuffer.this.debugging) {
                UsbSerialDebugger.printLogPut(src, true);
            }
            if (this.position + src.length > 16383) {
                if (this.position < 16384) {
                    System.arraycopy(src, 0, this.buffer, this.position, 16384 - this.position);
                }
                this.position = 16384;
                this.notify();
            } else {
                System.arraycopy(src, 0, this.buffer, this.position, src.length);
                this.position += src.length;
                this.notify();
            }
        }

        public synchronized byte[] get() {
            if (this.position == -1) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.position <= -1) {
                return new byte[0];
            }
            byte[] dst = Arrays.copyOfRange(this.buffer, 0, this.position);
            if (SerialBuffer.this.debugging) {
                UsbSerialDebugger.printLogGet(dst, true);
            }
            this.position = -1;
            return dst;
        }

        public synchronized void reset() {
            this.position = -1;
        }
    }
}

