/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.felhr.usbserial.UsbSpiDevice;

public class CP2130SpiDevice
extends UsbSpiDevice {
    private static String CLASS_ID = CP2130SpiDevice.class.getSimpleName();
    public static final int CLOCK_12MHz = 0;
    public static final int CLOCK_6MHz = 1;
    public static final int CLOCK_3MHz = 2;
    public static final int CLOCK_1_5MHz = 3;
    public static final int CLOCK_750KHz = 4;
    public static final int CLOCK_375KHz = 5;
    public static final int CLOCK_187_5KHz = 6;
    public static final int CLOCK_93_75KHz = 7;
    private static final int BM_REQ_DEVICE_2_HOST = 192;
    private static final int BM_REQ_HOST_2_DEVICE = 64;
    private static final int SET_SPI_WORD = 49;
    private static final int SET_GPIO_CHIP_SELECT = 37;
    private static final int GET_SPI_WORD = 48;
    private UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private UsbRequest requestIN;
    private int currentChannel;

    public CP2130SpiDevice(UsbDevice device, UsbDeviceConnection connection) {
        this(device, connection, -1);
    }

    public CP2130SpiDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        super(device, connection);
        this.mInterface = device.getInterface(iface >= 0 ? iface : 0);
        this.currentChannel = 0;
    }

    @Override
    public boolean connectSPI() {
        boolean ret = this.openCP2130();
        if (!ret) {
            return false;
        }
        this.restartWorkingThread();
        this.restartWriteThread();
        this.setThreadsParams(this.inEndpoint, this.outEndpoint);
        return true;
    }

    @Override
    public int getSelectedSlave() {
        return this.currentChannel;
    }

    @Override
    public void writeMOSI(byte[] buffer) {
        byte[] buffCommand = new byte[buffer.length + 8];
        buffCommand[0] = 0;
        buffCommand[1] = 0;
        buffCommand[2] = 1;
        buffCommand[3] = -128;
        buffCommand[4] = (byte)(buffer.length & 0xFF);
        buffCommand[5] = (byte)(buffer.length >> 8 & 0xFF);
        buffCommand[6] = (byte)(buffer.length >> 16 & 0xFF);
        buffCommand[7] = (byte)(buffer.length >> 24 & 0xFF);
        System.arraycopy(buffer, 0, buffCommand, 8, buffer.length);
        this.serialBuffer.putWriteBuffer(buffCommand);
    }

    @Override
    public void setClock(int clockDivider) {
        switch (clockDivider) {
            case 0: {
                this.setSetSpiWord(this.currentChannel, 0);
                break;
            }
            case 1: {
                this.setSetSpiWord(this.currentChannel, 1);
                break;
            }
            case 2: {
                this.setSetSpiWord(this.currentChannel, 2);
                break;
            }
            case 3: {
                this.setSetSpiWord(this.currentChannel, 3);
                break;
            }
            case 4: {
                this.setSetSpiWord(this.currentChannel, 4);
                break;
            }
            case 5: {
                this.setSetSpiWord(this.currentChannel, 5);
                break;
            }
            case 6: {
                this.setSetSpiWord(this.currentChannel, 6);
                break;
            }
            case 7: {
                this.setSetSpiWord(this.currentChannel, 7);
            }
        }
    }

    @Override
    public void readMISO(int lengthBuffer) {
        byte[] buffCommand = new byte[]{0, 0, 0, -128, (byte)(lengthBuffer & 0xFF), (byte)(lengthBuffer >> 8 & 0xFF), (byte)(lengthBuffer >> 16 & 0xFF), (byte)(lengthBuffer >> 24 & 0xFF)};
        this.serialBuffer.putWriteBuffer(buffCommand);
    }

    @Override
    public void writeRead(byte[] buffer, int lengthRead) {
        byte[] buffCommand = new byte[8 + buffer.length];
        buffCommand[0] = 0;
        buffCommand[1] = 0;
        buffCommand[2] = 2;
        buffCommand[3] = -128;
        buffCommand[4] = (byte)(lengthRead & 0xFF);
        buffCommand[5] = (byte)(lengthRead >> 8 & 0xFF);
        buffCommand[6] = (byte)(lengthRead >> 16 & 0xFF);
        buffCommand[7] = (byte)(lengthRead >> 24 & 0xFF);
        System.arraycopy(buffer, 0, buffCommand, 8, buffer.length);
        this.serialBuffer.putWriteBuffer(buffCommand);
    }

    @Override
    public void selectSlave(int nSlave) {
        if (nSlave > 10 || nSlave < 0) {
            Log.i((String)CLASS_ID, (String)"selected slave must be in 0-10 range");
            return;
        }
        this.setGpioChipSelect(nSlave, true);
    }

    @Override
    public int getClockDivider() {
        byte[] data = this.getSpiWord();
        return data[this.currentChannel] & 7;
    }

    @Override
    public void closeSPI() {
        this.killWorkingThread();
        this.killWriteThread();
        this.connection.releaseInterface(this.mInterface);
    }

    private boolean openCP2130() {
        if (!this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
            return false;
        }
        Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            this.outEndpoint = endpoint;
        }
        return true;
    }

    private void setSetSpiWord(int channel, int freq) {
        byte[] payload = new byte[2];
        if (channel < 0 || channel > 10) {
            Log.i((String)CLASS_ID, (String)"Channel not valid");
            return;
        }
        payload[0] = (byte)channel;
        payload[1] = (byte)freq;
        payload[1] = (byte)(payload[1] | 8);
        this.setControlCommandOut(49, 0, 0, payload);
    }

    private void setGpioChipSelect(int channel, boolean othersDisabled) {
        byte[] payload = new byte[2];
        if (channel < 0 || channel > 10) {
            Log.i((String)CLASS_ID, (String)"Channel not valid");
            return;
        }
        payload[0] = (byte)channel;
        int control = othersDisabled ? 2 : 1;
        payload[1] = control;
        int ret = this.setControlCommandOut(37, 0, 0, payload);
        if (ret != -1) {
            this.currentChannel = channel;
        }
    }

    private byte[] getSpiWord() {
        return this.setControlCommandIn(48, 0, 0, 2);
    }

    private int setControlCommandOut(int request, int value, int index, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(64, request, value, this.mInterface.getId(), data, dataLength, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    private byte[] setControlCommandIn(int request, int value, int index, int length) {
        byte[] data = new byte[length];
        int response = this.connection.controlTransfer(192, request, value, this.mInterface.getId(), data, length, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return data;
    }
}

