/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;
import java.util.concurrent.atomic.AtomicBoolean;

public class CH34xSerialDevice
extends UsbSerialDevice {
    private static final String CLASS_ID = CH34xSerialDevice.class.getSimpleName();
    private static final int DEFAULT_BAUDRATE = 9600;
    private static final int REQTYPE_HOST_FROM_DEVICE = 192;
    private static final int REQTYPE_HOST_TO_DEVICE = 64;
    private static final int CH341_REQ_WRITE_REG = 154;
    private static final int CH341_REQ_READ_REG = 149;
    private static final int CH341_REG_BREAK1 = 5;
    private static final int CH341_REG_BREAK2 = 24;
    private static final int CH341_NBREAK_BITS_REG1 = 1;
    private static final int CH341_NBREAK_BITS_REG2 = 64;
    private static final int CH34X_300_1312 = 55680;
    private static final int CH34X_300_0f2c = 235;
    private static final int CH34X_600_1312 = 25729;
    private static final int CH34X_600_0f2c = 118;
    private static final int CH34X_1200_1312 = 45697;
    private static final int CH34X_1200_0f2c = 59;
    private static final int CH34X_2400_1312 = 55681;
    private static final int CH34X_2400_0f2c = 30;
    private static final int CH34X_4800_1312 = 25730;
    private static final int CH34X_4800_0f2c = 15;
    private static final int CH34X_9600_1312 = 45698;
    private static final int CH34X_9600_0f2c = 8;
    private static final int CH34X_19200_1312 = 55682;
    private static final int CH34X_19200_0f2c_rest = 7;
    private static final int CH34X_38400_1312 = 25731;
    private static final int CH34X_57600_1312 = 39043;
    private static final int CH34X_115200_1312 = 52355;
    private static final int CH34X_230400_1312 = 59011;
    private static final int CH34X_460800_1312 = 62339;
    private static final int CH34X_921600_1312 = 62343;
    private static final int CH34X_PARITY_NONE = 195;
    private static final int CH34X_PARITY_ODD = 203;
    private static final int CH34X_PARITY_EVEN = 219;
    private static final int CH34X_PARITY_MARK = 235;
    private static final int CH34X_PARITY_SPACE = 251;
    private static final int CH34X_FLOW_CONTROL_NONE = 0;
    private static final int CH34X_FLOW_CONTROL_RTS_CTS = 257;
    private static final int CH34X_FLOW_CONTROL_DSR_DTR = 514;
    private UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private UsbRequest requestIN;
    private FlowControlThread flowControlThread;
    private UsbSerialInterface.UsbCTSCallback ctsCallback;
    private UsbSerialInterface.UsbDSRCallback dsrCallback;
    private boolean rtsCtsEnabled;
    private boolean dtrDsrEnabled;
    private boolean dtr = false;
    private boolean rts = false;
    private boolean ctsState = false;
    private boolean dsrState = false;

    public CH34xSerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        super(device, connection);
    }

    public CH34xSerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        super(device, connection);
        this.rtsCtsEnabled = false;
        this.dtrDsrEnabled = false;
        this.mInterface = device.getInterface(iface >= 0 ? iface : 0);
    }

    @Override
    public boolean open() {
        boolean ret = this.openCH34X();
        if (ret) {
            this.requestIN = new UsbRequest();
            this.requestIN.initialize(this.connection, this.inEndpoint);
            this.restartWorkingThread();
            this.restartWriteThread();
            this.createFlowControlThread();
            this.setThreadsParams(this.requestIN, this.outEndpoint);
            this.asyncMode = true;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.killWorkingThread();
        this.killWriteThread();
        this.stopFlowControlThread();
        this.connection.releaseInterface(this.mInterface);
    }

    @Override
    public boolean syncOpen() {
        boolean ret = this.openCH34X();
        if (ret) {
            this.createFlowControlThread();
            this.setSyncParams(this.inEndpoint, this.outEndpoint);
            this.asyncMode = false;
            return true;
        }
        return false;
    }

    @Override
    public void syncClose() {
        this.stopFlowControlThread();
        this.connection.releaseInterface(this.mInterface);
    }

    @Override
    public void setBaudRate(int baudRate) {
        int ret;
        if (baudRate <= 300) {
            int ret2 = this.setBaudRate(55680, 235);
            if (ret2 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 300 && baudRate <= 600) {
            int ret3 = this.setBaudRate(25729, 118);
            if (ret3 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 600 && baudRate <= 1200) {
            int ret4 = this.setBaudRate(45697, 59);
            if (ret4 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 1200 && baudRate <= 2400) {
            int ret5 = this.setBaudRate(55681, 30);
            if (ret5 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 2400 && baudRate <= 4800) {
            int ret6 = this.setBaudRate(25730, 15);
            if (ret6 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 4800 && baudRate <= 9600) {
            int ret7 = this.setBaudRate(45698, 8);
            if (ret7 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 9600 && baudRate <= 19200) {
            int ret8 = this.setBaudRate(55682, 7);
            if (ret8 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 19200 && baudRate <= 38400) {
            int ret9 = this.setBaudRate(25731, 7);
            if (ret9 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 38400 && baudRate <= 57600) {
            int ret10 = this.setBaudRate(39043, 7);
            if (ret10 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 57600 && baudRate <= 115200) {
            int ret11 = this.setBaudRate(52355, 7);
            if (ret11 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 115200 && baudRate <= 230400) {
            int ret12 = this.setBaudRate(59011, 7);
            if (ret12 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 230400 && baudRate <= 460800) {
            int ret13 = this.setBaudRate(62339, 7);
            if (ret13 == -1) {
                Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
            }
        } else if (baudRate > 460800 && baudRate <= 921600 && (ret = this.setBaudRate(62343, 7)) == -1) {
            Log.i((String)CLASS_ID, (String)"SetBaudRate failed!");
        }
    }

    @Override
    public void setDataBits(int dataBits) {
    }

    @Override
    public void setStopBits(int stopBits) {
    }

    @Override
    public void setParity(int parity) {
        switch (parity) {
            case 0: {
                this.setCh340xParity(195);
                break;
            }
            case 1: {
                this.setCh340xParity(203);
                break;
            }
            case 2: {
                this.setCh340xParity(219);
                break;
            }
            case 3: {
                this.setCh340xParity(235);
                break;
            }
            case 4: {
                this.setCh340xParity(251);
                break;
            }
        }
    }

    @Override
    public void setFlowControl(int flowControl) {
        switch (flowControl) {
            case 0: {
                this.rtsCtsEnabled = false;
                this.dtrDsrEnabled = false;
                this.setCh340xFlow(0);
                break;
            }
            case 1: {
                this.rtsCtsEnabled = true;
                this.dtrDsrEnabled = false;
                this.setCh340xFlow(257);
                this.ctsState = this.checkCTS();
                this.startFlowControlThread();
                break;
            }
            case 2: {
                this.rtsCtsEnabled = false;
                this.dtrDsrEnabled = true;
                this.setCh340xFlow(514);
                this.dsrState = this.checkDSR();
                this.startFlowControlThread();
                break;
            }
        }
    }

    @Override
    public void setRTS(boolean state) {
        this.rts = state;
        this.writeHandshakeByte();
    }

    @Override
    public void setDTR(boolean state) {
        this.dtr = state;
        this.writeHandshakeByte();
    }

    @Override
    public void getCTS(UsbSerialInterface.UsbCTSCallback ctsCallback) {
        this.ctsCallback = ctsCallback;
    }

    @Override
    public void getDSR(UsbSerialInterface.UsbDSRCallback dsrCallback) {
        this.dsrCallback = dsrCallback;
    }

    @Override
    public void getBreak(UsbSerialInterface.UsbBreakCallback breakCallback) {
    }

    @Override
    public void getFrame(UsbSerialInterface.UsbFrameCallback frameCallback) {
    }

    @Override
    public void getOverrun(UsbSerialInterface.UsbOverrunCallback overrunCallback) {
    }

    @Override
    public void getParity(UsbSerialInterface.UsbParityCallback parityCallback) {
    }

    private boolean openCH34X() {
        if (!this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
            return false;
        }
        Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            if (endpoint.getType() != 2 || endpoint.getDirection() != 0) continue;
            this.outEndpoint = endpoint;
        }
        return this.init() == 0;
    }

    private int init() {
        if (this.setControlCommandOut(161, 49820, 45753, null) < 0) {
            Log.i((String)CLASS_ID, (String)"init failed! #1");
            return -1;
        }
        if (this.setControlCommandOut(164, 223, 0, null) < 0) {
            Log.i((String)CLASS_ID, (String)"init failed! #2");
            return -1;
        }
        if (this.setControlCommandOut(164, 159, 0, null) < 0) {
            Log.i((String)CLASS_ID, (String)"init failed! #3");
            return -1;
        }
        if (this.checkState("init #4", 149, 1798, new int[]{159, 238}) == -1) {
            return -1;
        }
        if (this.setControlCommandOut(154, 10023, 0, null) < 0) {
            Log.i((String)CLASS_ID, (String)"init failed! #5");
            return -1;
        }
        if (this.setControlCommandOut(154, 4882, 45698, null) < 0) {
            Log.i((String)CLASS_ID, (String)"init failed! #6");
            return -1;
        }
        if (this.setControlCommandOut(154, 3884, 8, null) < 0) {
            Log.i((String)CLASS_ID, (String)"init failed! #7");
            return -1;
        }
        if (this.setControlCommandOut(154, 9496, 195, null) < 0) {
            Log.i((String)CLASS_ID, (String)"init failed! #8");
            return -1;
        }
        if (this.checkState("init #9", 149, 1798, new int[]{159, 238}) == -1) {
            return -1;
        }
        if (this.setControlCommandOut(154, 10023, 0, null) < 0) {
            Log.i((String)CLASS_ID, (String)"init failed! #10");
            return -1;
        }
        return 0;
    }

    private int setBaudRate(int index1312, int index0f2c) {
        if (this.setControlCommandOut(154, 4882, index1312, null) < 0) {
            return -1;
        }
        if (this.setControlCommandOut(154, 3884, index0f2c, null) < 0) {
            return -1;
        }
        if (this.checkState("set_baud_rate", 149, 1798, new int[]{159, 238}) == -1) {
            return -1;
        }
        if (this.setControlCommandOut(154, 10023, 0, null) < 0) {
            return -1;
        }
        return 0;
    }

    private int setCh340xParity(int indexParity) {
        if (this.setControlCommandOut(154, 9496, indexParity, null) < 0) {
            return -1;
        }
        if (this.checkState("set_parity", 149, 1798, new int[]{159, 238}) == -1) {
            return -1;
        }
        if (this.setControlCommandOut(154, 10023, 0, null) < 0) {
            return -1;
        }
        return 0;
    }

    private int setCh340xFlow(int flowControl) {
        if (this.checkState("set_flow_control", 149, 1798, new int[]{159, 238}) == -1) {
            return -1;
        }
        if (this.setControlCommandOut(154, 10023, flowControl, null) == -1) {
            return -1;
        }
        return 0;
    }

    private int checkState(String msg, int request, int value, int[] expected) {
        byte[] buffer = new byte[expected.length];
        int ret = this.setControlCommandIn(request, value, 0, buffer);
        if (ret != expected.length) {
            Log.i((String)CLASS_ID, (String)("Expected " + expected.length + " bytes, but get " + ret + " [" + msg + "]"));
            return -1;
        }
        return 0;
    }

    private boolean checkCTS() {
        byte[] buffer = new byte[2];
        int ret = this.setControlCommandIn(149, 1798, 0, buffer);
        if (ret != 2) {
            Log.i((String)CLASS_ID, (String)("Expected 2 bytes, but get " + ret));
            return false;
        }
        return (buffer[0] & 1) == 0;
    }

    private boolean checkDSR() {
        byte[] buffer = new byte[2];
        int ret = this.setControlCommandIn(149, 1798, 0, buffer);
        if (ret != 2) {
            Log.i((String)CLASS_ID, (String)("Expected 2 bytes, but get " + ret));
            return false;
        }
        return (buffer[0] & 2) == 0;
    }

    private int writeHandshakeByte() {
        if (this.setControlCommandOut(164, ~((this.dtr ? 32 : 0) | (this.rts ? 64 : 0)), 0, null) < 0) {
            Log.i((String)CLASS_ID, (String)"Failed to set handshake byte");
            return -1;
        }
        return 0;
    }

    private int setControlCommandOut(int request, int value, int index, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(64, request, value, index, data, dataLength, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    private int setControlCommandIn(int request, int value, int index, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(192, request, value, index, data, dataLength, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    private void createFlowControlThread() {
        this.flowControlThread = new FlowControlThread();
    }

    private void startFlowControlThread() {
        if (!this.flowControlThread.isAlive()) {
            this.flowControlThread.start();
        }
    }

    private void stopFlowControlThread() {
        if (this.flowControlThread != null) {
            this.flowControlThread.stopThread();
            this.flowControlThread = null;
        }
    }

    private class FlowControlThread
    extends Thread {
        private long time = 100L;
        private boolean firstTime = true;
        private AtomicBoolean keep = new AtomicBoolean(true);

        @Override
        public void run() {
            while (this.keep.get()) {
                if (!this.firstTime) {
                    if (CH34xSerialDevice.this.rtsCtsEnabled) {
                        boolean cts = this.pollForCTS();
                        if (CH34xSerialDevice.this.ctsState != cts) {
                            CH34xSerialDevice.this.ctsState = !CH34xSerialDevice.this.ctsState;
                            if (CH34xSerialDevice.this.ctsCallback != null) {
                                CH34xSerialDevice.this.ctsCallback.onCTSChanged(CH34xSerialDevice.this.ctsState);
                            }
                        }
                    }
                    if (!CH34xSerialDevice.this.dtrDsrEnabled) continue;
                    boolean dsr = this.pollForDSR();
                    if (CH34xSerialDevice.this.dsrState == dsr) continue;
                    CH34xSerialDevice.this.dsrState = !CH34xSerialDevice.this.dsrState;
                    if (CH34xSerialDevice.this.dsrCallback == null) continue;
                    CH34xSerialDevice.this.dsrCallback.onDSRChanged(CH34xSerialDevice.this.dsrState);
                    continue;
                }
                if (CH34xSerialDevice.this.rtsCtsEnabled && CH34xSerialDevice.this.ctsCallback != null) {
                    CH34xSerialDevice.this.ctsCallback.onCTSChanged(CH34xSerialDevice.this.ctsState);
                }
                if (CH34xSerialDevice.this.dtrDsrEnabled && CH34xSerialDevice.this.dsrCallback != null) {
                    CH34xSerialDevice.this.dsrCallback.onDSRChanged(CH34xSerialDevice.this.dsrState);
                }
                this.firstTime = false;
            }
        }

        public void stopThread() {
            this.keep.set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pollForCTS() {
            FlowControlThread flowControlThread = this;
            synchronized (flowControlThread) {
                try {
                    this.wait(this.time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return CH34xSerialDevice.this.checkCTS();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pollForDSR() {
            FlowControlThread flowControlThread = this;
            synchronized (flowControlThread) {
                try {
                    this.wait(this.time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return CH34xSerialDevice.this.checkDSR();
        }
    }
}

