/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanzezhen.security.facade.feign;

import com.alibaba.fastjson.JSON;
import com.github.fanzezhen.common.enums.auth.RoleEnum;
import com.github.fanzezhen.pojo.dto.SysPermissionDto;
import com.github.fanzezhen.pojo.dto.SysUserDto;
import com.github.fanzezhen.pojo.response.R;
import com.github.fanzezhen.security.facade.UserDetailsServiceFacade;
import com.github.fanzezhen.security.facade.feign.remote.UserDetailsRemote;
import com.github.fanzezhen.security.model.SysUserDetail;
import com.github.fanzezhen.security.property.SecurityProjectProperty;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.tomcat.util.buf.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class UserDetailsServiceFacadeImpl
implements UserDetailsServiceFacade {
    private static final Logger log = LoggerFactory.getLogger(UserDetailsServiceFacadeImpl.class);
    @Resource
    private SecurityProjectProperty securityProjectProperty;
    @Resource
    private UserDetailsRemote userDetailsRemote;

    public UserDetails loadUserDetails(CasAssertionAuthenticationToken casAssertionAuthenticationToken) throws UsernameNotFoundException {
        String username = casAssertionAuthenticationToken.getName();
        log.info("\u5f53\u524d\u7684\u7528\u6237\u540d\u662f\uff1a" + username);
        SysUserDetail userInfo = this.loadUserByUsername(username);
        log.info(userInfo.toString());
        return userInfo;
    }

    @Cacheable(value={"user_details"}, key="#username")
    public SysUserDetail loadUserByUsername(String username) throws UsernameNotFoundException {
        SysUserDto sysUserDto = (SysUserDto)this.userDetailsRemote.loadUserByUsername(username, this.securityProjectProperty.APP_CODE).getData();
        if (sysUserDto != null) {
            HashSet<CallSite> grantedAuthorityNameSet = new HashSet<CallSite>();
            if (!sysUserDto.getRoleTypeSets().isEmpty()) {
                for (SysPermissionDto sysPermissionDto : sysUserDto.getRoleTypeSets().contains(RoleEnum.RoleTypeEnum.SPECIAL_ADMIN.getType()) ? (List)this.userDetailsRemote.listPermission(this.securityProjectProperty.APP_CODE).getData() : sysUserDto.getSysPermissionDtoList()) {
                    grantedAuthorityNameSet.add((CallSite)((Object)("permission_" + sysPermissionDto.getId())));
                }
            }
            grantedAuthorityNameSet.addAll(RoleEnum.RoleTypeEnum.securityRoleTypeCodeSetByType((Collection)sysUserDto.getRoleTypeSets()));
            HashSet grantedAuthorities = new HashSet(AuthorityUtils.commaSeparatedStringToAuthorityList((String)StringUtils.join(grantedAuthorityNameSet, (char)',')));
            SysUserDetail sysUserDetail = new SysUserDetail(sysUserDto, grantedAuthorities);
            sysUserDetail.setRoleIds(sysUserDto.getRoleIdSets());
            sysUserDetail.setRoleNames(sysUserDto.getRoleNameSets());
            sysUserDetail.setRoleTypes(sysUserDto.getRoleTypeSets());
            return sysUserDetail;
        }
        throw new UsernameNotFoundException("user: " + username + " do not exist!");
    }

    @Override
    @Cacheable(value={"permission_details"}, key="#appCode")
    public List<SysPermissionDto> listAllPermissionDto(String appCode) {
        return (List)this.userDetailsRemote.listPermission(appCode).getData();
    }

    public static void main(String[] args) {
        SysUserDto sysUserDto = new SysUserDto();
        SysPermissionDto sysPermissionDto = new SysPermissionDto();
        sysPermissionDto.setId("1");
        sysPermissionDto.setName("\u6743\u96501");
        sysPermissionDto.setOperationUrl("/a");
        SysPermissionDto sysPermissionDto2 = new SysPermissionDto();
        sysPermissionDto2.setId("2");
        sysPermissionDto2.setName("\u6743\u96502");
        sysPermissionDto2.setOperationUrl("/b");
        ArrayList<SysPermissionDto> sysPermissionDtoList = new ArrayList<SysPermissionDto>();
        sysPermissionDtoList.add(sysPermissionDto);
        sysPermissionDtoList.add(sysPermissionDto2);
        sysUserDto.setSysPermissionDtoList(sysPermissionDtoList);
        sysUserDto.setRoleIdSets(new HashSet<String>(Arrays.asList("roleId-1", "roleId-2")));
        sysUserDto.setRoleNameSets(new HashSet<String>(Arrays.asList("roleName-1", "roleName-2")));
        sysUserDto.setRoleTypeSets(new HashSet<Integer>(Arrays.asList(1, 2)));
        sysUserDto.setId("id");
        sysUserDto.setUsername("1");
        sysUserDto.setPassword("1");
        sysUserDto.setNickname("1");
        sysUserDto.setEmail("1");
        sysUserDto.setPhone("1");
        sysUserDto.setUnitName("1");
        System.out.println(JSON.toJSONString((Object)R.ok((Object)sysUserDto)));
        System.out.println(JSON.toJSONString((Object)R.ok(sysPermissionDtoList)));
    }
}

