/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanzezhen.generator;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import com.github.fanzezhen.generator.GeneratorBean;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;

public class GeneratorTool {
    public static String scanner(String tip) {
        String ipt;
        Scanner scanner = new Scanner(System.in);
        System.out.println("\u8bf7\u8f93\u5165" + tip + "\uff1a");
        if (scanner.hasNext() && StringUtils.isNotEmpty((CharSequence)(ipt = scanner.next()))) {
            return ipt;
        }
        throw new MybatisPlusException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684" + tip + "\uff01");
    }

    public static void generator(final GeneratorBean generatorBean) {
        AutoGenerator mpg = new AutoGenerator();
        GlobalConfig gc = new GlobalConfig();
        final String projectPath = System.getProperty("user.dir");
        gc.setOutputDir(projectPath + "/" + generatorBean.getModuleName() + "/src/main/java");
        gc.setAuthor(generatorBean.getAuthor());
        gc.setOpen(false);
        gc.setIdType(IdType.ASSIGN_UUID);
        mpg.setGlobalConfig(gc);
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl(generatorBean.getDataSourceConfigUrl());
        dsc.setDriverName(generatorBean.getDriverName());
        dsc.setUsername(generatorBean.getDbUsername());
        dsc.setPassword(generatorBean.getDbPassword());
        mpg.setDataSource(dsc);
        PackageConfig pc = new PackageConfig();
        pc.setModuleName(generatorBean.getPackageName());
        pc.setParent(generatorBean.getModulePackageName());
        mpg.setPackageInfo(pc);
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
            }
        };
        ArrayList<2> focList = new ArrayList<2>();
        focList.add(new FileOutConfig("/templates/mapper.xml.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return projectPath + "/" + generatorBean.getModuleName() + "/src/main/resources/mapper/" + tableInfo.getEntityName() + "Mapper.xml";
            }
        });
        cfg.setFileOutConfigList(focList);
        mpg.setCfg(cfg);
        mpg.setTemplate(new TemplateConfig().setXml(null));
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        if (StringUtils.isNotEmpty((CharSequence)generatorBean.getSuperEntityClassName())) {
            strategy.setSuperEntityClass(generatorBean.getSuperEntityClassName());
            strategy.setSuperEntityColumns(generatorBean.getSuperEntityColumns());
        }
        strategy.setEntityLombokModel(true);
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(new String[]{"t_"});
        strategy.setInclude(generatorBean.getTables().split(generatorBean.getTableNameSplitter()));
        mpg.setStrategy(strategy);
        mpg.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        mpg.execute();
    }
}

