/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.junit;

import com.github.fakemongo.Fongo;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ServerVersion;
import com.mongodb.util.FongoJSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.List;
import java.util.UUID;
import org.bson.Document;
import org.junit.rules.ExternalResource;

public class FongoRule
extends ExternalResource {
    private final boolean realMongo;
    private final String dbName;
    private final Fongo fongo;
    private MongoClient mongo;
    private DB db;
    private MongoDatabase mongoDatabase;

    public FongoRule(String dbName, ServerVersion serverVersion, boolean realMongo, MongoClient mongoClientIfReal) {
        this.dbName = dbName;
        this.realMongo = realMongo || "true".equals(System.getProperty("fongo.force.realMongo"));
        this.fongo = realMongo ? null : this.newFongo(serverVersion);
        this.mongo = mongoClientIfReal;
    }

    public FongoRule() {
        this(Fongo.DEFAULT_SERVER_VERSION);
    }

    public FongoRule(ServerVersion serverVersion) {
        this(UUID.randomUUID().toString(), serverVersion, false, null);
    }

    public FongoRule(boolean realMongo) {
        this(realMongo, Fongo.DEFAULT_SERVER_VERSION);
    }

    public FongoRule(boolean realMongo, ServerVersion serverVersion) {
        this(UUID.randomUUID().toString(), serverVersion, realMongo, null);
    }

    public FongoRule(boolean realMongo, MongoClient mongoClientIfReal) {
        this(UUID.randomUUID().toString(), Fongo.DEFAULT_SERVER_VERSION, realMongo, mongoClientIfReal);
    }

    public FongoRule(String dbName, boolean realMongo) {
        this(dbName, Fongo.DEFAULT_SERVER_VERSION, realMongo, null);
    }

    public FongoRule(String dbName) {
        this(dbName, Fongo.DEFAULT_SERVER_VERSION, false, null);
    }

    public boolean isRealMongo() {
        return this.realMongo;
    }

    protected void before() throws UnknownHostException {
        if (this.realMongo) {
            if (this.mongo == null) {
                this.mongo = new MongoClient();
            }
        } else {
            this.mongo = this.fongo.getMongo();
        }
        this.db = this.mongo.getDB(this.dbName);
        this.mongoDatabase = this.mongo.getDatabase(this.dbName);
    }

    protected void after() {
        this.db.dropDatabase();
    }

    public DBCollection insertJSON(DBCollection coll, String json) {
        List<DBObject> objects = this.parseList(json);
        for (DBObject object : objects) {
            coll.insert(new DBObject[]{object});
        }
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBCollection insertFile(DBCollection coll, String filename) throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            while (line != null) {
                coll.insert(new DBObject[]{this.parseDBObject(line)});
                line = br.readLine();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return coll;
    }

    public List<DBObject> parseList(String json) {
        return (List)this.parse(json);
    }

    public DBObject parseDBObject(String json) {
        return (DBObject)this.parse(json);
    }

    public <T> T parse(String json) {
        return (T)FongoJSON.parse(json);
    }

    public DBCollection newCollection() {
        return this.newCollection(UUID.randomUUID().toString());
    }

    public DBCollection newCollection(String collectionName) {
        return this.db.getCollection(collectionName);
    }

    public MongoCollection<Document> newMongoCollection(String collectionName) {
        return this.mongoDatabase.getCollection(collectionName);
    }

    private Fongo newFongo(ServerVersion serverVersion) {
        return new Fongo("test", serverVersion);
    }

    public Fongo getFongo() {
        return this.fongo;
    }

    @Deprecated
    public DB getDb() {
        return this.db;
    }

    @Deprecated
    public DB getDb(String name) {
        return this.mongo.getDB(name);
    }

    public DB getDB() {
        return this.db;
    }

    public DB getDB(String name) {
        return this.mongo.getDB(name);
    }

    public MongoDatabase getDatabase(String name) {
        return this.mongo.getDatabase(name);
    }

    public MongoDatabase getDatabase() {
        return this.mongoDatabase;
    }

    @Deprecated
    public Mongo getMongo() {
        return this.mongo;
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }
}

